package jp.sourceforge.armadillo;

import java.io.*;

import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.lzh.*;

/**
 * LZH`A[JCu̓WJB
 */
public final class LzhExpander implements Expander {

    private LzhInputStream lis;

    /**
     * LzhExpander̐B
     * @param is InputStream
     */
    public LzhExpander(InputStream is) {
        this.lis = new LzhInputStream(is);
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#nextEntry()
     */
    public ArchiveEntry nextEntry() throws IOException {
        LzhEntry entry = lis.getNextEntry();
        if (entry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry ae = new ArchiveEntry(entry.getName());
        ae.setMethod(entry.getMethod());
        ae.setLastModified(entry.getLastModified());
        ae.setSize(entry.getSize());
        ae.setCompressedSize(entry.getCompressedSize());
        ae.setCrc(entry.getCrc());
        return ae;
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#expand(java.io.OutputStream)
     */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(lis, os);
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#close()
     */
    public void close() throws IOException {
        lis.close();
    }

}
