/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtilities {
    private static final int BUFFER_SIZE = 8192;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IOUtilities() {
    }

    public static boolean move(File file, File file2, boolean bl) throws IOException {
        if (file2.exists()) {
            if (bl) {
                file2.delete();
            } else {
                throw new IOException("file already exists: " + file2);
            }
        }
        IOUtilities.mkdirsIfNotExists(file2);
        return file.renameTo(file2);
    }

    public static void copy(File file, File file2, boolean bl) throws IOException {
        if (file2.exists() && !bl) {
            throw new IOException("file already exists: " + file2);
        }
        IOUtilities.copy(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File file, File file2) throws IOException {
        long l = file.lastModified();
        IOUtilities.mkdirsIfNotExists(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            long l2;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                long l3 = fileInputStream.getChannel().transferTo(0L, file.length(), fileOutputStream.getChannel());
                file2.setLastModified(l);
                l2 = l3;
            }
            catch (Throwable throwable) {
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            return l2;
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        long l2 = l;
        long l3 = 0L;
        int n = 8192;
        byte[] byArray = new byte[n];
        while (l2 > 0L) {
            long l4 = Math.min(l2, (long)n);
            if (!$assertionsDisabled && l4 > Integer.MAX_VALUE) {
                throw new AssertionError();
            }
            int n2 = inputStream.read(byArray, 0, (int)l4);
            if (!$assertionsDisabled && n2 == 0) {
                throw new AssertionError((Object)"Read Zero");
            }
            if (n2 < 0) break;
            outputStream.write(byArray, 0, n2);
            l2 -= (long)n2;
            l3 += (long)n2;
        }
        outputStream.flush();
        return l3;
    }

    public static long transferAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            if (!$assertionsDisabled && n == 0) {
                throw new AssertionError((Object)"Read Zero");
            }
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        return l;
    }

    private static void mkdirsIfNotExists(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new IOException("failed to mkdir: " + file2);
        }
    }

    static {
        $assertionsDisabled = !IOUtilities.class.desiredAssertionStatus();
    }
}

