/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Expander;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipInputStream;

public final class ZipExpander
implements Expander {
    private ZipInputStream zis;

    public ZipExpander(InputStream inputStream) {
        this.zis = new ZipInputStream(inputStream);
    }

    public ZipExpander(File file) throws IOException {
        this.zis = new ZipInputStream(file);
    }

    public ArchiveEntry nextEntry() throws IOException {
        ZipEntry zipEntry = this.zis.getNextEntry();
        if (zipEntry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry archiveEntry = new ArchiveEntry(zipEntry.getName());
        archiveEntry.setMethod(ZipExpander.getMethodName(zipEntry.getMethod()));
        archiveEntry.setLastModified(zipEntry.getLastModified());
        archiveEntry.setSize(zipEntry.getSize());
        archiveEntry.setCompressedSize(zipEntry.getCompressedSize());
        archiveEntry.setCrc(zipEntry.getCrc());
        return archiveEntry;
    }

    private static String getMethodName(int n) {
        switch (n) {
            case 8: {
                return "DEFLATED";
            }
            case 0: {
                return "STORED";
            }
        }
        return "UNKNOWN";
    }

    public long expand(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll(this.zis, outputStream);
    }

    public void close() throws IOException {
        this.zis.close();
    }
}

