/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Expander;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhInputStream;

public final class LzhExpander
implements Expander {
    private LzhInputStream lis;

    public LzhExpander(InputStream inputStream) {
        this.lis = new LzhInputStream(inputStream);
    }

    public ArchiveEntry nextEntry() throws IOException {
        LzhEntry lzhEntry = this.lis.getNextEntry();
        if (lzhEntry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry archiveEntry = new ArchiveEntry(lzhEntry.getName());
        archiveEntry.setMethod(lzhEntry.getMethod());
        archiveEntry.setLastModified(lzhEntry.getLastModified());
        archiveEntry.setSize(lzhEntry.getSize());
        archiveEntry.setCompressedSize(lzhEntry.getCompressedSize());
        archiveEntry.setCrc(lzhEntry.getCrc());
        return archiveEntry;
    }

    public long expand(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll(this.lis, outputStream);
    }

    public void close() throws IOException {
        this.lis.close();
    }
}

