/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.ArchiveType;
import jp.sourceforge.armadillo.Expander;
import jp.sourceforge.armadillo.LzhExpander;
import jp.sourceforge.armadillo.TarExpander;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.ZipExpander;

public final class FileExpander {
    private Expander expander;
    private PrintWriter out;
    private boolean verbose;

    public FileExpander(File file) throws IOException {
        this(file, ArchiveType.getType(file));
    }

    public FileExpander(File file, ArchiveType archiveType) throws IOException {
        this.expander = FileExpander.getExpander(file, archiveType);
        this.out = Utilities.getDefaultPrintWriter();
    }

    public void setOut(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("out is null");
        }
        this.out = printWriter;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void list() throws IOException {
        this.list(new String[0]);
    }

    public void list(String[] stringArray) throws IOException {
        ArchiveEntry archiveEntry;
        HashSet<String> hashSet;
        boolean bl;
        if (stringArray != null && stringArray.length > 0) {
            bl = false;
            hashSet = new HashSet<String>(Arrays.asList(stringArray));
        } else {
            bl = true;
            hashSet = Collections.EMPTY_SET;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        DecimalFormat decimalFormat = new DecimalFormat("###.0");
        while (!(archiveEntry = this.expander.nextEntry()).isNull()) {
            String string = archiveEntry.getName();
            if (!bl && !hashSet.contains(string)) continue;
            String string2 = "";
            if (archiveEntry.isDirectory()) {
                string2 = string2 + 'D';
                string2 = string2 + FileExpander.padSpace("", this.verbose ? 24 : 8, false);
            } else {
                long l = archiveEntry.getSize();
                string2 = string2 + FileExpander.padSpace(String.valueOf(l), 8, true);
                if (this.verbose) {
                    string2 = string2 + ' ';
                    long l2 = archiveEntry.getCompressedSize();
                    String string3 = l2 > 0L ? String.valueOf(l2) : "";
                    string2 = string2 + FileExpander.padSpace(string3, 8, true);
                    string2 = string2 + ' ';
                    if (l > 0L && l2 > 0L) {
                        float f = (float)l2 / 1.0f / (float)l * 100.0f;
                        string2 = string2 + FileExpander.padSpace(decimalFormat.format(f), 5, true);
                        string2 = string2 + '%';
                    } else {
                        string2 = string2 + "------";
                    }
                }
                string2 = string2 + ' ';
            }
            string2 = string2 + FileExpander.padSpace(archiveEntry.getMethod(), 6, false).substring(0, 6);
            string2 = string2 + ' ';
            string2 = string2 + simpleDateFormat.format(new Date(archiveEntry.getLastModified()));
            string2 = string2 + ' ';
            string2 = string2 + string;
            this.out.println(string2);
            this.out.flush();
        }
    }

    public void expand(File file) throws IOException {
        this.expand(file, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(File file, String[] stringArray) throws IOException {
        HashSet<String> hashSet;
        boolean bl;
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + file);
        }
        if (stringArray != null && stringArray.length > 0) {
            bl = false;
            hashSet = new HashSet<String>(Arrays.asList(stringArray));
        } else {
            bl = true;
            hashSet = Collections.EMPTY_SET;
        }
        try {
            File file2;
            Object object;
            ArchiveEntry archiveEntry;
            if (this.verbose) {
                this.out.println("begin to extract");
            }
            ArrayList<ArchiveEntry> arrayList = new ArrayList<ArchiveEntry>();
            while (!(archiveEntry = this.expander.nextEntry()).isNull()) {
                String string = archiveEntry.getName();
                if (!bl && !hashSet.contains(string)) continue;
                if (this.verbose) {
                    this.out.println("  extracting ... " + string);
                }
                object = new File(file, string);
                if (archiveEntry.isDirectory()) {
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                    arrayList.add(archiveEntry);
                    continue;
                }
                file2 = ((File)object).getParentFile();
                if (!file2.isDirectory()) {
                    file2.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                try {
                    this.expander.expand(fileOutputStream);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                ((File)object).setLastModified(archiveEntry.getLastModified());
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object = (ArchiveEntry)arrayList.get(i);
                file2 = new File(file, ((ArchiveEntry)object).getName());
                file2.setLastModified(((ArchiveEntry)object).getLastModified());
            }
            if (this.verbose) {
                this.out.println("end to extract");
            }
        }
        finally {
            this.expander.close();
        }
    }

    private static String padSpace(String string, int n, boolean bl) {
        if (string.length() > n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("        ");
        while (stringBuffer.length() < n) {
            stringBuffer.append(stringBuffer);
        }
        String string2 = stringBuffer.substring(string.length(), n);
        return bl ? string2 + string : string + string2;
    }

    public static Expander getExpander(File file) throws IOException {
        return FileExpander.getExpander(file, ArchiveType.getType(file));
    }

    public static Expander getExpander(File file, ArchiveType archiveType) throws IOException {
        if (archiveType == ArchiveType.TAR) {
            return new TarExpander(new FileInputStream(file));
        }
        if (archiveType == ArchiveType.TGZ) {
            return new TarExpander(new GZIPInputStream(new FileInputStream(file)));
        }
        if (archiveType == ArchiveType.ZIP) {
            return new ZipExpander(file);
        }
        if (archiveType == ArchiveType.LZH) {
            return new LzhExpander(new FileInputStream(file));
        }
        throw new IllegalStateException("File: " + file + ", ArchiverType: " + archiveType);
    }

    public void close() throws IOException {
        this.expander.close();
    }
}

