/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.ArchiveType;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.LzhArchiver;
import jp.sourceforge.armadillo.TarArchiver;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.ZipArchiver;

public final class FileArchiver
implements Archiver {
    private Archiver archiver;
    private PrintWriter out;
    private boolean verbose;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileArchiver(File file) throws IOException {
        this(file, ArchiveType.getType(file));
    }

    public FileArchiver(File file, ArchiveType archiveType) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (archiveType == ArchiveType.TAR) {
            this.archiver = new TarArchiver(fileOutputStream);
        } else if (archiveType == ArchiveType.TGZ) {
            this.archiver = new TarArchiver(new GZIPOutputStream(fileOutputStream));
        } else if (archiveType == ArchiveType.ZIP) {
            this.archiver = new ZipArchiver(fileOutputStream);
        } else if (archiveType == ArchiveType.LZH) {
            this.archiver = new LzhArchiver(fileOutputStream);
        } else {
            throw new IllegalStateException("ArchiverType: " + archiveType);
        }
        this.out = Utilities.getDefaultPrintWriter();
    }

    public void setOut(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("out is null");
        }
        this.out = printWriter;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void archive(File file) throws IOException {
        this.archive(file, FileArchiver.getRootPath(file));
    }

    private void archive(File file, String string) throws IOException {
        boolean bl = file.isDirectory();
        String string2 = FileArchiver.getEntryName(file, string, bl);
        ArchiveEntry archiveEntry = new ArchiveEntry(string2);
        try {
            archiveEntry.setLastModified(file.lastModified());
            if (bl) {
                this.addEntry(archiveEntry, file);
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    this.archive(fileArray[i], string);
                }
            } else {
                this.addEntry(archiveEntry, file);
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(iOException.getMessage() + " : entry=" + string2);
            iOException2.setStackTrace(iOException.getStackTrace());
            iOException2.initCause(iOException.getCause());
            throw iOException2;
        }
        if (!archiveEntry.isAdded()) {
            return;
        }
        if (this.verbose) {
            long l = archiveEntry.getSize();
            long l2 = archiveEntry.getCompressedSize();
            if (!($assertionsDisabled || l2 >= 0L && l >= 0L)) {
                throw new AssertionError();
            }
            this.out.print("appending  " + file);
            if (l == 0L || l2 == l) {
                this.out.print(" (STORED)");
            } else {
                int n = l2 == l ? 100 : (int)(l2 * 100L / l);
                this.out.print(" (" + n + "%, " + l + " => " + l2 + ")");
            }
            this.out.println();
        }
    }

    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        this.archiver.addEntry(archiveEntry, file);
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        this.archiver.addEntry(archiveEntry, inputStream, l);
    }

    private static String getRootPath(File file) {
        String string = FileArchiver.normalizePath(file.getAbsoluteFile().getParent());
        if (!string.endsWith(String.valueOf('/'))) {
            string = string + '/';
        }
        return string;
    }

    private static String getEntryName(File file, String string, boolean bl) {
        String string2;
        String string3 = FileArchiver.normalizePath(file.getAbsolutePath());
        if (string3.startsWith(string)) {
            string2 = string3.substring(string.length());
            if (file.isDirectory() && !string2.endsWith(String.valueOf('/'))) {
                string2 = string2 + '/';
            }
        } else {
            string2 = file.getName();
        }
        return string2;
    }

    private static String normalizePath(String string) {
        return string.replace('\\', '/');
    }

    public void close() throws IOException {
        this.archiver.close();
    }

    static {
        $assertionsDisabled = !FileArchiver.class.desiredAssertionStatus();
    }
}

