package jp.sourceforge.armadillo.lzh;

import java.io.*;

import jp.sourceforge.armadillo.io.*;

/**
 * LZH`A[JCũnt}@kR[hB
 * LH4,LH5,LH6,LH7ŎgpB
 */
public final class LzhHuffmanEncoder implements LzssEncoderWritable {

    private static final int BUFFER_SIZE = 4096;

    private BitOutputStream out;
    private int threshold;
    private int index;
    private int[] symbolBuffer;
    private int[] offsetBuffer;

    /**
     * LzhHuffmanEncoder̐B
     * @param out OutputStream
     * @param threshold 臒l
     */
    public LzhHuffmanEncoder(OutputStream out, int threshold) {
        this.out = new BitOutputStream(out);
        this.threshold = threshold;
        this.index = 0;
        this.symbolBuffer = new int[BUFFER_SIZE];
        this.offsetBuffer = new int[BUFFER_SIZE];
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.lzh.LzssEncoderWritable#writeSymbol(int, boolean)
     */
    public void writeSymbol(int symbol) throws IOException {
        symbolBuffer[index++] = symbol;
        if (index >= BUFFER_SIZE) {
            encode();
        }
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.lzh.LzssEncoderWritable#writeCode(int, int)
     */
    public void writeCode(int offset, int length) throws IOException {
        assert length >= threshold;
        symbolBuffer[index] = length - threshold + 0x100;
        offsetBuffer[index++] = offset - 1;
        if (index >= BUFFER_SIZE) {
            encode();
        }
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.lzh.LzssEncoderWritable#flush()
     */
    public void flush() throws IOException {
        encode();
    }

    /*
     * C:code table
     * L:code length table
     * T1:L̃nt}\
     * T2:L̃nt}\̃̕nt}\
     * T3:vʒũrbg̃nt}\
     */
    private int[] ct1, lt1, ct2, lt2, ct3, lt3;
    private int t1size;

    /**
     * B
     * @throws IOException o̓G[ꍇ
     */
    private void encode() throws IOException {
        if (index == 0) {
            return;
        }
        try {
            createTables();
            outputCodes();
        } catch (RuntimeException ex) {
            IOException exception = new LzhException("huffman encoding error");
            exception.initCause(ex);
            throw exception;
        } finally {
            index = 0;
            ct1 = null;
            lt1 = null;
            ct2 = null;
            lt2 = null;
            ct3 = null;
            lt3 = null;
        }
    }

    /**
     * e[u̐B
     */
    private void createTables() {
        // T1
        int[] ft1 = new int[512];
        for (int i = 0; i < index; i++) {
            int c = symbolBuffer[i];
            ++ft1[c];
        }
        LzhHuffmanTable table1 = LzhHuffmanTable.build(ft1);
        ct1 = table1.codeTable;
        lt1 = table1.codeLengthTable;
        t1size = getTrimmedSize(lt1);
        int size = getTrimmedSize(lt1);
        int[] ft = new int[512];
        for (int i1 = 0; i1 < size;) {
            int length = lt1[i1++];
            if (length == 0) {
                int count = 1;
                while (i1 < size && lt1[i1] == 0) {
                    ++i1;
                    ++count;
                }
                if (count <= 2) {
                    ft[0] += count;
                } else if (count <= 18) {
                    ++ft[1];
                } else if (count == 19) {
                    ++ft[0];
                    ++ft[1];
                } else {
                    ++ft[2];
                }
            } else {
                int p = length + 2;
                ++ft[p];
            }
        }
        // T2
        LzhHuffmanTable table2 = LzhHuffmanTable.build(ft);
        ct2 = table2.codeTable;
        lt2 = table2.codeLengthTable;
        // T3
        int[] ft3 = new int[17];
        for (int i = 0; i < index; i++) {
            if (symbolBuffer[i] < 0x100) {
                continue;
            }
            int offset = offsetBuffer[i];
            int bitLength = 0;
            while (true) {
                if (offset < 1 << bitLength) {
                    break;
                }
                ++bitLength;
            }
            ++ft3[bitLength];
        }
        LzhHuffmanTable table3 = LzhHuffmanTable.build(ft3);
        ct3 = table3.codeTable;
        lt3 = table3.codeLengthTable;
    }

    /**
     * o͂B
     * @throws IOException o̓G[ꍇ
     */
    private void outputCodes() throws IOException {
        // LZSS̗vf
        int t2size = getTrimmedSize(lt2);
        out.writeBits(index, 16);
        // T2
        out.writeBits(t2size, 5);
        for (int i = 0; i < t2size;) {
            int length = lt2[i++];
            if (length <= 6) {
                out.writeBits(length, 3);
            } else {
                out.writeBits(0xFFFFFFFF, length - 4);
                out.writeBits(0, 1);
            }
            if (i == 3) {
                while (i < 6 && lt2[i] == 0) {
                    ++i;
                }
                out.writeBits(i - 3, 2);
            }
        }
        // T1e[uTCY
        out.writeBits(t1size, 9);
        // T1
        for (int i = 0; i < t1size;) {
            int length = lt1[i++];
            if (length == 0) {
                int count = 1;
                while (i < t1size && lt1[i] == 0) {
                    ++i;
                    ++count;
                }
                if (count <= 2) {
                    for (int j = 0; j < count; j++) {
                        out.writeBits(ct2[0], lt2[0]);
                    }
                } else if (count <= 18) {
                    out.writeBits(ct2[1], lt2[1]);
                    out.writeBits(count - 3, 4);
                } else if (count == 19) {
                    out.writeBits(ct2[0], lt2[0]);
                    out.writeBits(ct2[1], lt2[1]);
                    out.writeBits(15, 4);
                } else {
                    out.writeBits(ct2[2], lt2[2]);
                    out.writeBits(count - 20, 9);
                }
            } else {
                out.writeBits(ct2[length + 2], lt2[length + 2]);
            }
        }
        // T3
        int t3size = getTrimmedSize(lt3);
        out.writeBits(t3size, 4);
        for (int i = 0; i < t3size;) {
            int length = lt3[i++];
            if (length <= 6) {
                out.writeBits(length, 3);
            } else {
                out.writeBits(0xFFFFFFFF, length - 4);
                out.writeBits(0, 1);
            }
        }
        // LZSS
        for (int i = 0; i < index; i++) {
            int symbol = symbolBuffer[i];
            out.writeBits(ct1[symbol], lt1[symbol]);
            if (symbol >= 0x100) {
                int offset = offsetBuffer[i];
                int offsetBitLength = 1;
                while (true) {
                    if (offset < 1 << offsetBitLength) {
                        break;
                    }
                    ++offsetBitLength;
                }
                if (offset == 0) {
                    offsetBitLength = 0;
                }
                out.writeBits(ct3[offsetBitLength], lt3[offsetBitLength]);
                if (offsetBitLength > 1) {
                    out.writeBits(offset, offsetBitLength - 1);
                }
            }
        }
        out.flush();
    }

    /**
     * zg(̃[ׂď)Ƃ̃TCYZoB
     * @param a intz
     * @return TCY
     */
    private static int getTrimmedSize(int[] a) {
        int i = a.length;
        while (i > 0 && a[i - 1] == 0) {
            --i;
        }
        return i;
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.lzh.LzssEncoderWritable#close()
     */
    public void close() throws IOException {
        try {
            flush();
        } finally {
            out.close();
        }
    }

}
