package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * A[JCȕo̓Xg[B
 */
public abstract class ArchiveOutputStream extends FilterOutputStream {

    protected OutputStream frontStream;
    protected long written;

    private boolean closed;

    /**
     * ArchiveOutputStream̐B
     * @param out OutputStream
     */
    public ArchiveOutputStream(OutputStream out) {
        super(out);
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    protected final void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream closed");
        }
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(int)
     */
    public void write(int b) throws IOException {
        ensureOpen();
        if (frontStream == null) {
            throw new IllegalStateException("stream is null");
        }
        frontStream.write(b);
        ++written;
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(byte[], int, int)
     */
    public void write(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        if (frontStream == null) {
            throw new IllegalStateException("stream is null");
        }
        frontStream.write(b, off, len);
        written += len;
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#flush()
     */
    public void flush() throws IOException {
        ensureOpen();
        if (frontStream != null) {
            frontStream.flush();
        }
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#close()
     */
    public void close() throws IOException {
        try {
            flush();
        } finally {
            closed = true;
            try {
                out.flush();
                super.close();
            } finally {
                frontStream = null;
            }
        }
    }

}
