package jp.sourceforge.armadillo;

import java.io.*;

/**
 * R}hB
 * R\[sꂽ̐U蕪sB
 */
public final class Command {

    /**
     * Command̐B
     */
    private Command() {
        // empty
    }

    /**
     * ̎sB
     * @param args p[^
     * @throws IllegalArgumentException p[^s̏ꍇ
     * @throws IOException o̓G[ꍇ
     */
    private static void execute(String[] args) throws IOException {
        if (args.length < 2) {
            throw new IllegalArgumentException("It needs at least 2 parameters");
        }
        String option = args[0];
        if (!option.matches("[ctx]v?f?")) {
            throw new IllegalArgumentException("invalid option: " + option);
        }
        assert option.length() >= 1;
        char mode = option.charAt(0);
        if (mode == 'c' && args.length < 3) {
            throw new IllegalArgumentException("mode 'c' needs at least 3 parameters");
        }
        boolean verbose = option.indexOf('v') > 0;
        File archiveFile = new File(args[1]);
        if (mode == 'c' && archiveFile.exists()) {
            System.out.print("archive file '"
                             + archiveFile.getName()
                             + "' already exists, overwrite? (y/N)");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String line = in.readLine();
            if (line == null || !line.equals("y")) {
                if (verbose) {
                    System.out.println("cancelled.");
                }
                return;
            }
        }
        String[] targetNames = new String[args.length - 2];
        System.arraycopy(args, 2, targetNames, 0, targetNames.length);
        switch (mode) {
            case 'c':
                archive(archiveFile, targetNames, verbose);
                break;
            case 't':
                list(archiveFile, targetNames, verbose);
                break;
            case 'x':
                expand(archiveFile, targetNames, verbose);
                break;
            default:
        }
    }

    /**
     * t@CA[JCuB
     * @param archiveFile A[JCut@C
     * @param targetNames Ώۖ̃Xg
     * @param verbose verbose[h̏ꍇ <code>true</code>
     * @throws IOException o̓G[ꍇ
     */
    private static void archive(File archiveFile, String[] targetNames, boolean verbose) throws IOException {
        ArchiveType type = ArchiveType.getType(archiveFile);
        if (type == ArchiveType.UNKNOWN) {
            throw new IllegalArgumentException("invalid file suffix: " + archiveFile.getName());
        }
        File[] targets = new File[targetNames.length];
        for (int i = 0; i < targets.length; i++) {
            File file = new File(targetNames[i]);
            if (!file.isDirectory() && !file.canRead()) {
                throw new IOException("invalid target: " + file);
            }
            targets[i] = file;
        }
        FileArchiver archiver = new FileArchiver(archiveFile, type);
        try {
            archiver.setVerbose(verbose);
            for (int i = 0; i < targets.length; i++) {
                File file = targets[i];
                archiver.archive(file);
            }
        } finally {
            archiver.close();
        }
        if (verbose) {
            System.out.println("finished.");
        }
    }

    /**
     * A[JCut@C̓e\B
     * @param archiveFile A[JCut@C
     * @param targetNames Ώۖ̃Xg
     * @param verbose verbose[h̏ꍇ <code>true</code>
     * @throws IOException o̓G[ꍇ
     */
    private static void list(File archiveFile, String[] targetNames, boolean verbose) throws IOException {
        FileExpander expander = new FileExpander(archiveFile);
        try {
            expander.setVerbose(verbose);
            if (targetNames.length > 0) {
                expander.list(targetNames);
            } else {
                expander.list();
            }
        } finally {
            expander.close();
        }
    }

    /**
     * A[JCut@CWJB
     * @param archiveFile A[JCut@C
     * @param targetNames Ώۖ̃Xg
     * @param verbose verbose[h̏ꍇ <code>true</code>
     * @throws IOException o̓G[ꍇ
     */
    private static void expand(File archiveFile, String[] targetNames, boolean verbose) throws IOException {
        FileExpander expander = new FileExpander(archiveFile);
        try {
            expander.setVerbose(verbose);
            File dstdir = new File(".");
            if (targetNames.length > 0) {
                expander.expand(dstdir, targetNames);
            } else {
                expander.expand(dstdir);
            }
        } finally {
            expander.close();
        }
    }

    /**
     * g̕\B
     */
    private static void printUsage() {
        System.out.println("usage: arm [ctx][v][f] archive-file target [target...]");
    }

    /**
     * R}h̎sB
     * @param args p[^
     * @throws Exception Cӂ̗O
     */
    public static void main(String[] args) throws Exception {
        try {
            if (args.length < 1 || args[0].equals("-h") || args[0].equals("--help")) {
                System.out.println("armadillo - archiving utility");
                System.out.println(Version.getVersionString(true));
                printUsage();
            } else {
                execute(args);
            }
        } catch (IllegalArgumentException ex) {
            System.err.println("armadillo: parameter error - " + ex.getMessage());
            printUsage();
            System.exit(1);
        } catch (IOException ex) {
            System.err.println("armadillo: I/O error - " + ex.getMessage());
            String propName = "jp.sourceforge.armadillo.debug";
            if (!System.getProperty(propName, "false").equalsIgnoreCase("false")) {
                throw ex;
            }
            System.exit(1);
        }
    }

}
