/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.zip.ZipEntry;

public final class ZipHeader {
    static final int SIGN_LOC = 67324752;
    static final int SIGN_EXT = 134695760;
    static final int SIGN_CEN = 33639248;
    static final int SIGN_END = 101010256;
    static final int LENGTH_LOC = 30;
    static final int LENGTH_EXT = 16;
    static final int LENGTH_CEN = 46;
    static final int LENGTH_END = 22;
    private static final short SHORT_0 = 0;
    private ByteBuffer buffer = ByteBuffer.allocate(46).order(ByteOrder.LITTLE_ENDIAN);
    private String charsetName;
    private boolean charsetEnables;
    private List entries;
    private long offset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipHeader() {
        this(null);
    }

    public ZipHeader(String string) {
        this.charsetName = string;
        this.charsetEnables = string != null && Charset.isSupported(string);
        this.entries = new ArrayList();
        this.offset = 0L;
    }

    public ZipEntry read(InputStream inputStream) throws IOException {
        this.buffer.clear();
        this.buffer.limit(30);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            return null;
        }
        this.buffer.rewind();
        int n = this.buffer.getInt();
        if (n == 33639248 || n == 101010256) {
            return null;
        }
        if (n != 67324752) {
            throw new ZipException("invalid LOC header: signature=" + Integer.toHexString(n));
        }
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.version = this.buffer.getShort();
        zipEntry.option = this.buffer.getShort();
        zipEntry.method = this.buffer.getShort();
        zipEntry.lastModified = Utilities.DosTime.toMilliSeconds(this.buffer.getInt());
        zipEntry.crc = (long)this.buffer.getInt() & 0xFFFFFFFFL;
        zipEntry.compressedSize = (long)this.buffer.getInt() & 0xFFFFFFFFL;
        zipEntry.size = (long)this.buffer.getInt() & 0xFFFFFFFFL;
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        byte[] byArray = new byte[s];
        if (inputStream.read(byArray) != s) {
            throw new ZipException("invalid LOC header (name length)");
        }
        String string = zipEntry.name = this.charsetEnables ? new String(byArray, this.charsetName) : new String(byArray);
        if (s2 > 0 && inputStream.skip(s2) != (long)s2) {
            throw new ZipException("invalid LOC header (extra length)");
        }
        return zipEntry;
    }

    public ZipEntry readEXT(InputStream inputStream) throws IOException {
        this.buffer.clear();
        this.buffer.limit(16);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            return null;
        }
        this.buffer.rewind();
        int n = this.buffer.getInt();
        if (n != 134695760) {
            throw new ZipException("invalid EXT header: signature=" + Integer.toHexString(n));
        }
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.crc = (long)this.buffer.getInt() & 0xFFFFFFFFL;
        zipEntry.compressedSize = (long)this.buffer.getInt() & 0xFFFFFFFFL;
        zipEntry.size = (long)this.buffer.getInt() & 0xFFFFFFFFL;
        return zipEntry;
    }

    public void write(OutputStream outputStream, ZipEntry zipEntry) throws IOException {
        zipEntry.position = (int)this.offset;
        this.buffer.clear();
        this.buffer.putInt(67324752);
        this.buffer.putShort(zipEntry.version);
        this.buffer.putShort(zipEntry.option);
        this.buffer.putShort((short)zipEntry.getMethod());
        this.buffer.putInt(Utilities.DosTime.getValue(zipEntry.lastModified));
        if (zipEntry.hasEXT()) {
            this.buffer.putInt(0);
            this.buffer.putInt(0);
            this.buffer.putInt(0);
        } else {
            this.buffer.putInt((int)zipEntry.crc);
            this.buffer.putInt((int)zipEntry.compressedSize);
            this.buffer.putInt((int)zipEntry.size);
            if (!$assertionsDisabled && zipEntry.compressedSize < 0L) {
                throw new AssertionError();
            }
            this.offset += zipEntry.compressedSize;
        }
        byte[] byArray = this.toBytes(zipEntry.name);
        short s = (short)byArray.length;
        if (s > Short.MAX_VALUE) {
            throw new ZipException("too long name: length=" + s);
        }
        short s2 = 0;
        this.buffer.putShort(s);
        this.buffer.putShort(s2);
        if (!$assertionsDisabled && this.buffer.position() != 30) {
            throw new AssertionError();
        }
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.write(byArray);
        outputStream.flush();
        this.entries.add(zipEntry);
        this.offset += (long)(30 + s + s2);
    }

    public void writeEXT(OutputStream outputStream, ZipEntry zipEntry) throws IOException {
        this.buffer.clear();
        this.buffer.putInt(134695760);
        this.buffer.putInt((int)zipEntry.crc);
        this.buffer.putInt((int)zipEntry.compressedSize);
        this.buffer.putInt((int)zipEntry.size);
        if (!$assertionsDisabled && this.buffer.position() != 16) {
            throw new AssertionError();
        }
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.flush();
        this.offset += 16L;
        if (!$assertionsDisabled && !zipEntry.hasEXT()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && zipEntry.compressedSize < 0L) {
            throw new AssertionError();
        }
        this.offset += zipEntry.compressedSize;
    }

    public void writeCEN(OutputStream outputStream, ZipEntry zipEntry) throws IOException {
        this.buffer.clear();
        this.buffer.putInt(33639248);
        this.buffer.putShort(zipEntry.version);
        this.buffer.putShort(zipEntry.version);
        this.buffer.putShort(zipEntry.option);
        this.buffer.putShort((short)zipEntry.method);
        this.buffer.putInt(Utilities.DosTime.getValue(zipEntry.lastModified));
        this.buffer.putInt((int)zipEntry.crc);
        this.buffer.putInt((int)zipEntry.compressedSize);
        this.buffer.putInt((int)zipEntry.size);
        byte[] byArray = this.toBytes(zipEntry.name);
        short s = (short)byArray.length;
        if (s > Short.MAX_VALUE) {
            throw new ZipException("too long name: length=" + s);
        }
        this.buffer.putShort(s);
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)0);
        this.buffer.putInt(0);
        this.buffer.putInt(zipEntry.position);
        if (!$assertionsDisabled && this.buffer.position() != 46) {
            throw new AssertionError();
        }
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.write(byArray);
        outputStream.flush();
        this.offset += (long)(46 + s);
    }

    public void writeEND(OutputStream outputStream) throws IOException {
        long l = this.offset;
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            ZipEntry zipEntry = (ZipEntry)this.entries.get(i);
            this.writeCEN(outputStream, zipEntry);
        }
        long l2 = this.offset - l;
        if (!($assertionsDisabled || l >= 0L && l <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || l2 >= 0L && l2 <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        this.buffer.clear();
        this.buffer.putInt(101010256);
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)this.entries.size());
        this.buffer.putShort((short)this.entries.size());
        this.buffer.putInt((int)l2);
        this.buffer.putInt((int)l);
        this.buffer.putShort((short)0);
        if (!$assertionsDisabled && this.buffer.position() != 22) {
            throw new AssertionError();
        }
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.flush();
        this.offset += 22L;
    }

    public void clearEntries() {
        this.entries.clear();
        this.offset = 0L;
    }

    private byte[] toBytes(String string) throws UnsupportedEncodingException {
        if (this.charsetEnables) {
            return string.getBytes(this.charsetName);
        }
        return string.getBytes();
    }

    static {
        $assertionsDisabled = !ZipHeader.class.desiredAssertionStatus();
    }
}

