/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.IOException;
import java.io.OutputStream;
import jp.sourceforge.armadillo.io.ArchiveOutputStream;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhHeader;
import jp.sourceforge.armadillo.lzh.LzhHuffmanEncoder;
import jp.sourceforge.armadillo.lzh.LzhMethod;
import jp.sourceforge.armadillo.lzh.LzssOutputStream;

public final class LzhOutputStream
extends ArchiveOutputStream {
    private LzhHeader header;

    public LzhOutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    public LzhOutputStream(OutputStream outputStream, String string) {
        super(outputStream);
        this.header = new LzhHeader(string);
        this.frontStream = outputStream;
    }

    public void putNextEntry(LzhEntry lzhEntry) throws IOException {
        String string = lzhEntry.getMethod();
        LzhMethod lzhMethod = new LzhMethod(string);
        this.frontStream = lzhMethod.isCompressing() ? new LzssOutputStream(new LzhHuffmanEncoder(this.out, lzhMethod.getThreshold()), lzhMethod.getDictionarySize(), lzhMethod.getMatchSize(), lzhMethod.getThreshold()) : this.out;
        this.header.write(this.out, lzhEntry);
    }

    public void closeEntry() throws IOException {
        this.frontStream.flush();
        if (this.frontStream != this.out) {
            this.frontStream.close();
        }
        this.frontStream = this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
            this.out.write(0);
            this.out.flush();
        }
        finally {
            try {
                super.close();
            }
            finally {
                this.header = null;
            }
        }
    }
}

