/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BitOutputStream
extends FilterOutputStream {
    private static final int INT_BITSIZE = 32;
    private static final int OUTPUT_BITSIZE = 8;
    private boolean closed = false;
    private int buffer;
    private int buffered;

    public BitOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream already closed");
        }
    }

    public void writeBits(int n, int n2) throws IOException {
        this.ensureOpen();
        if (1 <= n2 && n2 <= 16) {
            if (this.buffered + n2 >= 32) {
                this.flushBuffer();
            }
            int n3 = n << 32 - n2;
            this.buffer |= (n3 >>>= this.buffered);
            this.buffered += n2;
        } else if (17 <= n2 && n2 <= 32) {
            this.writeBits(n >>> 16, n2 - 16);
            this.writeBits(n, 16);
        } else {
            throw new IllegalArgumentException("value=" + n + ", bit length=" + n2);
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        this.writeBits((byte)n, 8);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        for (int i = n; i < n + n2; ++i) {
            this.writeBits(byArray[i], 8);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
        super.flush();
    }

    private void flushBuffer() throws IOException {
        while (this.buffered >= 8) {
            int n = this.buffer >>> 24;
            super.write(n);
            this.buffer <<= 8;
            this.buffered -= 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.ensureOpen();
        try {
            if (this.buffered > 0) {
                this.buffered += 7;
            }
            this.flush();
        }
        finally {
            this.buffered = 0;
            this.closed = true;
        }
    }
}

