/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BitInputStream
extends FilterInputStream {
    private static final int INT_BITSIZE = 32;
    private static final int INPUT_BITSIZE = 8;
    private boolean closed = false;
    private int buffer = 0;
    private int remaining = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BitInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream already closed");
        }
    }

    public int readBits(int n) throws IOException {
        this.ensureOpen();
        if (n < 1 || 32 < n) {
            throw new IllegalArgumentException("bit length: " + n);
        }
        if (this.remaining < n) {
            this.fillBuffer(n - this.remaining);
            if (this.remaining < n) {
                return -1;
            }
        }
        int n2 = this.buffer >>> 32 - n;
        this.remaining -= n;
        this.buffer <<= n;
        return n2;
    }

    public int readBit() throws IOException {
        return this.readBits(1);
    }

    public int prefetchBits(int n) throws IOException {
        this.ensureOpen();
        if (this.remaining < n) {
            this.fillBuffer(n);
            if (this.remaining < n) {
                return -1;
            }
        }
        return this.buffer >>> 32 - n;
    }

    private void fillBuffer(int n) throws IOException {
        int n2;
        if (!$assertionsDisabled && n < 1) {
            throw new AssertionError();
        }
        if (this.remaining + n > 32) {
            throw new IllegalArgumentException("overflow: " + this.remaining + ", " + n);
        }
        for (n2 = 0; n2 < n; n2 += 8) {
            int n3 = super.read();
            if (n3 == -1) {
                if (n2 != 0) break;
                return;
            }
            if (!$assertionsDisabled && (this.buffer | (n3 <<= 24 - this.remaining)) != this.buffer + n3) {
                throw new AssertionError();
            }
            this.buffer |= n3;
            this.remaining += 8;
        }
        if (n2 < n) {
            throw new IOException("requred=" + n + ", buffered=" + n2);
        }
    }

    public void clearBuffer() {
        this.buffer = 0;
        this.remaining = 0;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public int read() throws IOException {
        return this.readBits(8);
    }

    public void close() throws IOException {
        this.ensureOpen();
        this.closed = true;
        super.close();
    }

    static {
        $assertionsDisabled = !BitInputStream.class.desiredAssertionStatus();
    }
}

