/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ArchiveInputStream
extends FilterInputStream {
    protected InputStream frontStream;
    protected long remaining = 0L;
    private boolean closed = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArchiveInputStream(InputStream inputStream) {
        super(inputStream);
    }

    protected final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            return super.read();
        }
        if (this.remaining <= 0L) {
            if (!$assertionsDisabled && this.remaining != 0L) {
                throw new AssertionError();
            }
            return -1;
        }
        int n = this.frontStream.read();
        if (n == -1) {
            return -1;
        }
        --this.remaining;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            return super.read(byArray, n, n2);
        }
        if (this.remaining <= 0L) {
            if (!$assertionsDisabled && this.remaining != 0L) {
                throw new AssertionError();
            }
            return -1;
        }
        int n3 = this.frontStream.read(byArray, n, (int)Math.min((long)n2, this.remaining));
        if (!$assertionsDisabled && n3 == 0) {
            throw new AssertionError((Object)"Read Zero");
        }
        if (n3 >= 0) {
            this.remaining -= (long)n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            return super.skip(l);
        }
        if (this.remaining <= 0L) {
            if (!$assertionsDisabled && this.remaining != 0L) {
                throw new AssertionError();
            }
            return -1L;
        }
        long l2 = this.frontStream.skip(l);
        if (l2 > 0L) {
            this.remaining -= l2;
        }
        return l2;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.closed = true;
        try {
            super.close();
        }
        finally {
            this.frontStream = null;
        }
    }

    static {
        $assertionsDisabled = !ArchiveInputStream.class.desiredAssertionStatus();
    }
}

