/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.tar.TarEntry;
import jp.sourceforge.armadillo.tar.TarOutputStream;

public final class TarArchiver
implements Archiver {
    private TarOutputStream tos;
    private boolean includesDirectory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TarArchiver(OutputStream outputStream) {
        this.tos = new TarOutputStream(outputStream);
        this.includesDirectory = true;
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        if (file.isDirectory()) {
            if (!this.includesDirectory) {
                return;
            }
            this.addDirectoryEntry(archiveEntry);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                archiveEntry.setSize(file.length());
                this.addFileEntry(archiveEntry, fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        archiveEntry.setAdded(true);
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            if (!this.includesDirectory) {
                return;
            }
            this.addDirectoryEntry(archiveEntry);
        } else {
            archiveEntry.setSize(l);
            this.addFileEntry(archiveEntry, inputStream);
        }
        archiveEntry.setAdded(true);
    }

    private void addDirectoryEntry(ArchiveEntry archiveEntry) throws IOException {
        TarEntry tarEntry = new TarEntry(archiveEntry.getName());
        tarEntry.setMode(0);
        tarEntry.setLastModified(archiveEntry.getLastModified());
        this.tos.putNextEntry(tarEntry);
        this.tos.closeEntry();
        archiveEntry.setCrc(0L);
        archiveEntry.setSize(0L);
        archiveEntry.setCompressedSize(0L);
    }

    private void addFileEntry(ArchiveEntry archiveEntry, InputStream inputStream) throws IOException {
        TarEntry tarEntry = new TarEntry(archiveEntry.getName());
        tarEntry.setLastModified(archiveEntry.getLastModified());
        tarEntry.setSize(archiveEntry.getSize());
        this.tos.putNextEntry(tarEntry);
        long l = IOUtilities.transferAll(inputStream, this.tos);
        tarEntry.setSize(l);
        this.tos.closeEntry();
        if (!$assertionsDisabled && l != archiveEntry.getSize()) {
            throw new AssertionError((Object)"file size");
        }
        if (!$assertionsDisabled && tarEntry.getSize() != archiveEntry.getSize()) {
            throw new AssertionError((Object)"file size");
        }
        archiveEntry.setCrc(0L);
        archiveEntry.setSize(l);
        archiveEntry.setCompressedSize(l);
    }

    public void close() throws IOException {
        this.tos.close();
    }

    static {
        $assertionsDisabled = !TarArchiver.class.desiredAssertionStatus();
    }
}

