package jp.sourceforge.armadillo.lzh;

import java.io.*;

/**
 * LZSS(XCfBO)k̏o̓Xg[B
 */
public final class LzssOutputStream extends FilterOutputStream {

    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;

    private boolean closed;
    private LzssEncoderWritable output;
    private byte[] buffer;
    private int index;
    private int limit;

    /**
     * LzssOutputStream̐B
     * @param output LzssEncoderWritable
     * @param dictionarySize TCY
     * @param matchSize őv
     * @param threshold 臒l
     */
    public LzssOutputStream(LzssEncoderWritable output,
                            int dictionarySize,
                            int matchSize,
                            int threshold) {
        super(null);
        this.closed = false;
        this.output = output;
        this.dictionarySize = dictionarySize;
        this.matchSize = matchSize;
        this.threshold = threshold;
        this.buffer = new byte[dictionarySize];
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    private void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream already closed");
        }
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(int)
     */
    public void write(int b) throws IOException {
        ensureOpen();
        write(new byte[]{(byte)b}, 0, 1);
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(byte[], int, int)
     */
    public void write(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        int remaining = len;
        int offset = off;
        while (remaining > 0) {
            final int rest = dictionarySize - limit;
            final int length = (remaining > rest) ? rest : remaining;
            java.lang.System.arraycopy(b, offset, buffer, limit, length);
            remaining -= length;
            offset += length;
            limit += length;
            if (length == rest) {
                flush();
            }
        }
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#flush()
     */
    public void flush() throws IOException {
        ensureOpen();
        while (index < limit) {
            /*
             * FjAȒT
             */
            int mark = -1;
            int length = 0;
            for (int i = index - 1; i >= 0; i--) {
                if (i + length >= limit
                    || index + length >= limit
                    || buffer[i] != buffer[index]
                    || buffer[i + length] != buffer[index + length]) {
                    continue;
                }
                int matched = 0;
                while (matched < matchSize && index + matched < limit) {
                    if (buffer[i + matched] == buffer[index + matched]) {
                        ++matched;
                    } else {
                        break;
                    }
                }
                if (matched > length) {
                    mark = i;
                    length = matched;
                }
            }
            int offset = (length >= threshold) ? index - mark : -1;
            if (offset >= 0) {
                output.writeCode(offset, length);
                index += length;
            } else {
                output.writeSymbol(buffer[index++] & 0xFF);
            }
        }
        if (limit > dictionarySize - matchSize) {
            index -= matchSize;
            limit -= matchSize;
            java.lang.System.arraycopy(buffer, matchSize, buffer, 0, limit);
        }
        output.flush();
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#close()
     */
    public void close() throws IOException {
        ensureOpen();
        try {
            flush();
        } finally {
            buffer = null;
            output.close();
            output = null;
        }
    }

}
