package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * ݃TCYoo̓Xg[B
 * o͓e͔jB 
 */
public final class SizeDetectionOutputStream extends FilterOutputStream {

    private long size;

    /**
     * SizeDetectionOutputStream̐B
     */
    public SizeDetectionOutputStream() {
        super(null);
        this.size = 0;
    }

    /**
     * ܂ꂽf[^̃TCY̎擾B
     * @return TCY
     */
    public long getSize() {
        return size;
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(int)
     */
    public void write(int b) throws IOException {
        ++size;
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(byte[])
     */
    public void write(byte[] b) throws IOException {
        size += b.length;
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(byte[], int, int)
     */
    public void write(byte[] b, int off, int len) throws IOException {
        size += len;
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#flush()
     */
    public void flush() throws IOException {
        // empty
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#close()
     */
    public void close() throws IOException {
        // empty
    }

}
