package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * rbgPʂ݂̏\OutputStreamB
 */
public final class BitOutputStream extends FilterOutputStream {

    /**
     * <code>int</code>̃rbgB
     */
    private static final int INT_BITSIZE = 32;

    /**
     * o͂ւ̓ǂݍ݃rbgB
     */
    private static final int OUTPUT_BITSIZE = 8;

    private boolean closed;
    private int buffer;
    private int buffered;

    /**
     * BitOutputStream̐B
     * @param out OutputStream
     */
    public BitOutputStream(OutputStream out) {
        super(out);
        this.closed = false;
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    private void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream already closed");
        }
    }

    /**
     * rbgPʂŏށB
     * intl̂ʃrbgw肳ꂽrbg̃f[^ށB
     * @param b intl(ő32rbg)
     * @param bitLength rbg
     * @throws IOException o̓G[ꍇ 
     */
    public void writeBits(int b, int bitLength) throws IOException {
        ensureOpen();
        if (1 <= bitLength && bitLength <= 16) {
            if (buffered + bitLength >= INT_BITSIZE) {
                flushBuffer();
            }
            int value = b << (INT_BITSIZE - bitLength);
            value >>>= buffered;
            buffer |= value;
            buffered += bitLength;
        } else if (17 <= bitLength && bitLength <= 32) {
            writeBits(b >>> 16, bitLength - 16);
            writeBits(b, 16);
        } else {
            throw new IllegalArgumentException("value=" + b + ", bit length=" + bitLength);
        }
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(int)
     */
    public void write(int b) throws IOException {
        ensureOpen();
        writeBits((byte)b, 8);
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#write(byte[], int, int)
     */
    public void write(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        for (int i = off; i < off + len; i++) {
            writeBits(b[i], 8);
        }
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#flush()
     */
    public void flush() throws IOException {
        ensureOpen();
        flushBuffer();
        super.flush();
    }

    /**
     * obt@oB
     * @throws IOException o̓G[ꍇ
     */
    private void flushBuffer() throws IOException {
        while (buffered >= OUTPUT_BITSIZE) {
            int value = buffer >>> (INT_BITSIZE - OUTPUT_BITSIZE);
            super.write(value);
            buffer <<= OUTPUT_BITSIZE;
            buffered -= OUTPUT_BITSIZE;
        }
    }

    /* (overridden)
     * @see java.io.FilterOutputStream#close()
     */
    public void close() throws IOException {
        ensureOpen();
        try {
            if (buffered > 0) {
                buffered += OUTPUT_BITSIZE - 1;
            }
            flush();
            //            super.close();
        } finally {
            buffered = 0;
            closed = true;
        }
    }

}
