/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.lzh.CRC16;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhException;

public final class LzhHeader {
    private static final int BUFFER_SIZE = 1024;
    private static final int LEVEL_OFFSET = 20;
    private static final String ISO_8859_1 = "iso-8859-1";
    private static final String ERROR_PREFIX = "invalid header: ";
    private ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
    private String charsetName;
    private boolean charsetEnables;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhHeader() {
        this(null);
    }

    public LzhHeader(String string) {
        this.charsetName = string;
        this.charsetEnables = string != null && Charset.isSupported(string);
    }

    public LzhEntry read(InputStream inputStream) throws IOException {
        LzhEntry lzhEntry;
        int n;
        this.buffer.clear();
        this.buffer.limit(21);
        Channels.newChannel(inputStream).read(this.buffer);
        int n2 = this.buffer.position();
        if (n2 == 0 || n2 == 1 && this.buffer.get(0) == 0) {
            return null;
        }
        if (n2 != 21) {
            throw new LzhException("invalid header: header count = " + n2);
        }
        byte by = this.buffer.get(20);
        this.buffer.rewind();
        switch (by) {
            case 0: 
            case 1: {
                n = this.buffer.get() + 2;
                break;
            }
            case 2: {
                n = this.buffer.getShort();
                break;
            }
            default: {
                throw new LzhException("unsupported header level: " + by);
            }
        }
        if (n == 0) {
            return null;
        }
        if (!($assertionsDisabled || n >= 0 && n < 1024)) {
            throw new AssertionError((Object)("header length = " + n));
        }
        this.buffer.limit(n);
        this.buffer.position(21);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() != n) {
            throw new LzhException("invalid header: header length = " + n);
        }
        switch (by) {
            case 0: {
                lzhEntry = this.readLevel0();
                break;
            }
            case 1: {
                lzhEntry = this.readLevel1(inputStream);
                break;
            }
            case 2: {
                lzhEntry = this.readLevel2();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected state");
            }
        }
        if (!lzhEntry.directory && (lzhEntry.name.endsWith("/") || lzhEntry.getMethod().equals("-lhd-"))) {
            lzhEntry.directory = true;
        }
        return lzhEntry;
    }

    private LzhEntry readLevel0() throws LzhException {
        this.buffer.position(1);
        LzhEntry lzhEntry = new LzhEntry();
        byte by = this.buffer.get();
        if (this.calculateChecksum(2, this.buffer.limit()) != by) {
            throw new LzhException("invalid header: checksum error");
        }
        lzhEntry.method = this.nextString(5);
        lzhEntry.compressedSize = this.buffer.getInt();
        lzhEntry.size = this.buffer.getInt();
        lzhEntry.lastModified = Utilities.DosTime.toMilliSeconds(this.buffer.getInt());
        lzhEntry.type = this.buffer.get();
        lzhEntry.headerLevel = this.buffer.get();
        byte by2 = this.buffer.get();
        lzhEntry.name = this.nextString(by2);
        lzhEntry.crc = this.buffer.getShort();
        return lzhEntry;
    }

    private LzhEntry readLevel1(InputStream inputStream) throws IOException {
        this.buffer.position(1);
        LzhEntry lzhEntry = new LzhEntry();
        byte by = this.buffer.get();
        if (this.calculateChecksum(2, this.buffer.limit()) != by) {
            throw new LzhException("invalid header: checksum error");
        }
        lzhEntry.method = this.nextString(5);
        lzhEntry.compressedSize = this.buffer.getInt();
        lzhEntry.size = this.buffer.getInt();
        lzhEntry.lastModified = (long)this.buffer.getInt() * 1000L;
        byte by2 = this.buffer.get();
        if (!$assertionsDisabled && by2 != 32) {
            throw new AssertionError();
        }
        lzhEntry.headerLevel = this.buffer.get();
        byte by3 = this.buffer.get();
        lzhEntry.name = this.nextString(by3);
        lzhEntry.crc = this.buffer.getShort();
        lzhEntry.type = this.buffer.get();
        short s = this.buffer.getShort(this.buffer.limit() - 2);
        while (s != 0) {
            if (!$assertionsDisabled && s <= 0) {
                throw new AssertionError();
            }
            byte[] byArray = new byte[s];
            if (inputStream.read(byArray) != s) {
                throw new LzhException("invalid header: invalid extend header");
            }
            s = 0;
            s = (short)(s | byArray[byArray.length - 1] << 8);
            s = (short)(s | byArray[byArray.length - 2]);
        }
        return lzhEntry;
    }

    private LzhEntry readLevel2() throws LzhException {
        this.buffer.position(2);
        LzhEntry lzhEntry = new LzhEntry();
        lzhEntry.method = this.nextString(5);
        lzhEntry.compressedSize = this.buffer.getInt();
        lzhEntry.size = this.buffer.getInt();
        lzhEntry.lastModified = (long)this.buffer.getInt() * 1000L;
        byte by = this.buffer.get();
        if (!$assertionsDisabled && by != 32) {
            throw new AssertionError();
        }
        lzhEntry.headerLevel = this.buffer.get();
        lzhEntry.crc = this.buffer.getShort();
        lzhEntry.osIdentifier = (char)this.buffer.get();
        int n = 0;
        short s = 0;
        while ((s = this.buffer.getShort()) > 0) {
            int n2 = s - 3;
            byte by2 = this.buffer.get();
            this.buffer.mark();
            switch (by2) {
                case 0: {
                    short s2 = this.buffer.getShort();
                    if (s2 == lzhEntry.crc) break;
                    throw new LzhException("invalid header: bad CRC");
                }
                case 1: 
                case 2: {
                    String string = this.nextPathString(n2, '/');
                    if (by2 == 1 && string.length() == 0) {
                        lzhEntry.directory = true;
                    }
                    lzhEntry.name = lzhEntry.name + string;
                    break;
                }
                case 57: {
                    ++n;
                    break;
                }
                case 65: {
                    this.buffer.getLong();
                    lzhEntry.lastModified = Utilities.WindowsTime.toMilliSeconds(this.buffer.getLong());
                    this.buffer.getLong();
                    break;
                }
                case 66: {
                    lzhEntry.compressedSize = this.buffer.getLong();
                    lzhEntry.size = this.buffer.getLong();
                    break;
                }
                case 84: {
                    lzhEntry.lastModified = (long)this.buffer.get() * 1000L;
                    break;
                }
            }
            this.buffer.reset();
            this.buffer.position(this.buffer.position() + n2);
        }
        if (!$assertionsDisabled && n != 0) {
            throw new AssertionError();
        }
        return lzhEntry;
    }

    public void write(OutputStream outputStream, LzhEntry lzhEntry) throws IOException {
        if (!lzhEntry.method.matches("-l[hz][a-z0-9]-")) {
            throw new LzhException("invalid compression type: " + lzhEntry.method);
        }
        if (lzhEntry.compressedSize > Integer.MAX_VALUE) {
            throw new LzhException("too large compressed size: " + lzhEntry.compressedSize);
        }
        if (lzhEntry.size > Integer.MAX_VALUE) {
            throw new LzhException("too large size: " + lzhEntry.size);
        }
        this.buffer.clear();
        switch (lzhEntry.headerLevel) {
            case 0: {
                this.writeLevel0(lzhEntry);
                break;
            }
            case 1: {
                this.writeLevel1(lzhEntry);
                break;
            }
            case 2: {
                this.writeLevel2(lzhEntry);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid header: header-level=" + lzhEntry.headerLevel);
            }
        }
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
    }

    private void writeLevel0(LzhEntry lzhEntry) throws IOException {
        byte[] byArray = this.charsetEnables ? lzhEntry.name.getBytes(this.charsetName) : lzhEntry.name.getBytes();
        int n = byArray.length;
        if (!($assertionsDisabled || n > 0 && n < 256)) {
            throw new AssertionError();
        }
        this.buffer.position(2);
        this.buffer.put(lzhEntry.method.getBytes(ISO_8859_1));
        this.buffer.putInt((int)lzhEntry.compressedSize);
        this.buffer.putInt((int)lzhEntry.size);
        this.buffer.putInt(Utilities.DosTime.getValue(lzhEntry.lastModified));
        this.buffer.put((byte)32);
        this.buffer.put((byte)0);
        this.buffer.put((byte)n);
        this.buffer.put(byArray);
        this.buffer.putShort(lzhEntry.crc);
        int n2 = this.buffer.position();
        int n3 = n2 - 2;
        if (!($assertionsDisabled || n3 > 0 && n3 < 256)) {
            throw new AssertionError();
        }
        int n4 = this.calculateChecksum(2, n2);
        this.buffer.put(0, (byte)n3);
        this.buffer.put(1, (byte)n4);
    }

    private void writeLevel1(LzhEntry lzhEntry) throws IOException {
        byte[] byArray = this.charsetEnables ? lzhEntry.name.getBytes(this.charsetName) : lzhEntry.name.getBytes();
        int n = byArray.length;
        if (!($assertionsDisabled || n > 0 && n < 256)) {
            throw new AssertionError();
        }
        this.buffer.position(2);
        this.buffer.put(lzhEntry.method.getBytes(ISO_8859_1));
        this.buffer.putInt((int)lzhEntry.compressedSize);
        this.buffer.putInt((int)lzhEntry.size);
        this.buffer.putInt(Utilities.DosTime.getValue(lzhEntry.lastModified));
        this.buffer.put((byte)32);
        this.buffer.put((byte)1);
        this.buffer.put((byte)n);
        this.buffer.put(byArray);
        this.buffer.putShort(lzhEntry.crc);
        this.buffer.putChar('J');
        this.buffer.putShort((short)0);
        int n2 = this.buffer.position();
        int n3 = n2 - 2;
        if (!($assertionsDisabled || n3 > 0 && n3 < 256)) {
            throw new AssertionError();
        }
        int n4 = this.calculateChecksum(2, n2);
        this.buffer.put(0, (byte)n3);
        this.buffer.put(1, (byte)n4);
    }

    private void writeLevel2(LzhEntry lzhEntry) throws IOException {
        int n;
        this.buffer.position(2);
        this.buffer.put(lzhEntry.method.getBytes(ISO_8859_1));
        this.buffer.putInt((int)lzhEntry.compressedSize);
        this.buffer.putInt((int)lzhEntry.size);
        this.buffer.putInt((int)(lzhEntry.lastModified / 1000L));
        this.buffer.put((byte)32);
        this.buffer.put((byte)2);
        this.buffer.putShort(lzhEntry.crc);
        this.buffer.put((byte)74);
        this.buffer.putShort((short)5);
        this.buffer.put((byte)0);
        this.buffer.putShort((short)0);
        CRC16 cRC16 = CRC16.newInstanceForHeader();
        cRC16.reset();
        cRC16.update(this.buffer.array(), 0, this.buffer.position() + 1);
        byte[] byArray = this.charsetEnables ? lzhEntry.name.getBytes(this.charsetName) : lzhEntry.name.getBytes();
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            byte by = byArray[n];
            if (by != 47 && by != 92) continue;
            byArray[n] = -1;
            int n3 = n - n2 + 1;
            this.buffer.putShort((short)(n3 + 3));
            this.buffer.put((byte)2);
            this.buffer.put(byArray, n2, n3);
            n2 = n + 1;
        }
        if (n2 < byArray.length) {
            n = byArray.length - n2;
            this.buffer.putShort((short)(n + 3));
            this.buffer.put((byte)1);
            this.buffer.put(byArray, n2, n);
        }
        this.buffer.putShort((short)0);
        n = this.buffer.position();
        if (n % 256 == 0) {
            this.buffer.put((byte)0);
            ++n;
        }
        this.buffer.putShort(0, (short)n);
    }

    private int calculateChecksum(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += this.buffer.get(i) & 0xFF;
        }
        return n3 & 0xFF;
    }

    private String nextString(int n) {
        byte[] byArray = this.buffer.array();
        int n2 = this.buffer.position();
        this.buffer.position(n2 + n);
        return new String(byArray, n2, n);
    }

    private String nextPathString(int n, char c) {
        byte[] byArray = this.buffer.array();
        int n2 = this.buffer.position();
        for (int i = 0; i < n; ++i) {
            if ((byArray[n2 + i] & 0xFF) != 255) continue;
            byArray[n2 + i] = (byte)c;
        }
        this.buffer.position(n2 + n);
        if (this.charsetEnables) {
            try {
                return new String(byArray, n2, n, this.charsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return new String(byArray, n2, n);
    }

    static {
        $assertionsDisabled = !LzhHeader.class.desiredAssertionStatus();
    }
}

