/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.io.SizeDetectionOutputStream;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipOutputStream;

public final class ZipArchiver
implements Archiver {
    private ZipOutputStream zos;
    private boolean includesDirectory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipArchiver(OutputStream outputStream) {
        this.zos = new ZipOutputStream(outputStream);
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        long l = file.length();
        if (file.isDirectory()) {
            if (!this.includesDirectory) {
                return;
            }
            this.addDirectoryEntry(archiveEntry);
        } else {
            archiveEntry.setSize(l);
            if (l > 0L) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                try {
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    InputStream inputStream = Channels.newInputStream(fileChannel);
                    ArchiveEntry archiveEntry2 = new ArchiveEntry(archiveEntry.getName());
                    ZipArchiver.tryOut(archiveEntry2, inputStream);
                    archiveEntry.setCrc(archiveEntry2.getCrc());
                    long l2 = archiveEntry2.getCompressedSize();
                    fileChannel.position(0L);
                    if (l2 < l) {
                        archiveEntry.setCompressedSize(l2);
                    } else {
                        archiveEntry.setCompressedSize(l);
                    }
                    this.addFileEntry(archiveEntry, inputStream);
                }
                finally {
                    randomAccessFile.close();
                }
            } else {
                this.addFileEntry(archiveEntry, null);
            }
        }
        archiveEntry.setAdded(true);
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            if (!this.includesDirectory) {
                return;
            }
            this.addDirectoryEntry(archiveEntry);
        } else {
            archiveEntry.setSize(l);
            this.addFileEntry(archiveEntry, inputStream);
        }
        archiveEntry.setAdded(true);
    }

    private void addDirectoryEntry(ArchiveEntry archiveEntry) throws IOException {
        ZipEntry zipEntry = new ZipEntry(archiveEntry.getName());
        zipEntry.setMethod(0);
        zipEntry.setCrc(0L);
        zipEntry.setSize(0L);
        zipEntry.setCompressedSize(0L);
        zipEntry.setLastModified(archiveEntry.getLastModified());
        this.zos.putNextEntry(zipEntry);
        this.zos.closeEntry();
        archiveEntry.setCrc(0L);
        archiveEntry.setSize(0L);
        archiveEntry.setCompressedSize(0L);
    }

    private void addFileEntry(ArchiveEntry archiveEntry, InputStream inputStream) throws IOException {
        long l = archiveEntry.getSize();
        long l2 = archiveEntry.getCompressedSize();
        ZipEntry zipEntry = new ZipEntry(archiveEntry.getName());
        zipEntry.setLastModified(archiveEntry.getLastModified());
        if (l2 <= 0L) {
            zipEntry.setOption((short)8);
        }
        if (l2 > 0L && l2 < l) {
            zipEntry.setMethod(8);
        } else {
            zipEntry.setMethod(0);
        }
        zipEntry.setCrc(archiveEntry.getCrc());
        zipEntry.setSize(l);
        zipEntry.setCompressedSize(archiveEntry.getCompressedSize());
        this.zos.putNextEntry(zipEntry);
        long l3 = 0L;
        if (l > 0L) {
            l3 = IOUtilities.transferAll(inputStream, this.zos);
        }
        this.zos.closeEntry();
        if (!$assertionsDisabled && l3 != l) {
            throw new AssertionError((Object)"file size");
        }
        if (!$assertionsDisabled && zipEntry.getSize() != l) {
            throw new AssertionError((Object)"file size");
        }
        if (!$assertionsDisabled && zipEntry.getCompressedSize() != l2) {
            throw new AssertionError((Object)"comp size");
        }
        archiveEntry.setCrc(zipEntry.getCrc());
        archiveEntry.setSize(l3);
        archiveEntry.setCompressedSize(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryOut(ArchiveEntry archiveEntry, InputStream inputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry();
        SizeDetectionOutputStream sizeDetectionOutputStream = new SizeDetectionOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(sizeDetectionOutputStream);
        try {
            zipEntry.setOption((short)8);
            zipEntry.setMethod(8);
            zipOutputStream.putNextEntry(zipEntry);
            IOUtilities.transferAll(inputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        finally {
            zipOutputStream.close();
        }
        if (!$assertionsDisabled && zipEntry.getCompressedSize() != sizeDetectionOutputStream.getSize()) {
            throw new AssertionError();
        }
        archiveEntry.setCrc(zipEntry.getCrc());
        archiveEntry.setSize(zipEntry.getSize());
        archiveEntry.setCompressedSize(zipEntry.getCompressedSize());
    }

    public void close() throws IOException {
        this.zos.close();
    }

    static {
        $assertionsDisabled = !ZipArchiver.class.desiredAssertionStatus();
    }
}

