/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;

public final class Utilities {
    private Utilities() {
    }

    public static File createTemporaryFile() throws IOException {
        File file = File.createTempFile("armadillo", ".tmp");
        file.deleteOnExit();
        return file;
    }

    static PrintWriter getDefaultPrintWriter() {
        return new PrintWriter(System.out, true);
    }

    public static final class WindowsTime {
        private WindowsTime() {
        }

        public static long toMilliSeconds(long l) {
            return ((l >>> 1) - 58222368000000000L) / 5000L;
        }
    }

    public static final class DosTime {
        private DosTime() {
        }

        public static int getValue(long l) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            return calendar.get(1) - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) / 2;
        }

        public static long toMilliSeconds(int n) {
            int n2 = (n >>> 25 & 0x7F) + 1980;
            int n3 = n >>> 21 & 0xF;
            int n4 = n >>> 16 & 0x1F;
            int n5 = n >>> 11 & 0x1F;
            int n6 = n >>> 5 & 0x3F;
            int n7 = (n & 0x1F) * 2;
            Calendar calendar = Calendar.getInstance();
            calendar.set(n2, n3 - 1, n4, n5, n6, n7);
            return calendar.getTimeInMillis();
        }
    }
}

