/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Expander;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.tar.TarEntry;
import jp.sourceforge.armadillo.tar.TarInputStream;

public final class TarExpander
implements Expander {
    private TarInputStream tis;

    public TarExpander(InputStream inputStream) {
        this.tis = new TarInputStream(inputStream);
    }

    public ArchiveEntry nextEntry() throws IOException {
        TarEntry tarEntry = this.tis.getNextEntry();
        if (tarEntry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry archiveEntry = new ArchiveEntry(tarEntry.getName());
        archiveEntry.setLastModified(tarEntry.getLastModified());
        archiveEntry.setSize(tarEntry.getSize());
        return archiveEntry;
    }

    public long expand(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll(this.tis, outputStream);
    }

    public void close() throws IOException {
        this.tis.close();
    }
}

