/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import jp.sourceforge.armadillo.ArchiveType;
import jp.sourceforge.armadillo.FileArchiver;
import jp.sourceforge.armadillo.FileExpander;
import jp.sourceforge.armadillo.Version;

public final class Command {
    static final /* synthetic */ boolean $assertionsDisabled;

    private Command() {
    }

    private static void execute(String[] stringArray) throws IOException {
        Object object;
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("It needs at least 2 parameters");
        }
        String string = stringArray[0];
        if (!string.matches("[ctx]v?f?")) {
            throw new IllegalArgumentException("invalid option: " + string);
        }
        if (!$assertionsDisabled && string.length() < 1) {
            throw new AssertionError();
        }
        char c = string.charAt(0);
        if (c == 'c' && stringArray.length < 3) {
            throw new IllegalArgumentException("mode 'c' needs at least 3 parameters");
        }
        boolean bl = string.indexOf(118) > 0;
        File file = new File(stringArray[1]);
        if (c == 'c' && file.exists()) {
            System.out.print("archive file '" + file.getName() + "' already exists, overwrite? (y/N)");
            object = new BufferedReader(new InputStreamReader(System.in));
            String string2 = ((BufferedReader)object).readLine();
            if (string2 == null || !string2.equals("y")) {
                if (bl) {
                    System.out.println("cancelled.");
                }
                return;
            }
        }
        object = new String[stringArray.length - 2];
        System.arraycopy(stringArray, 2, object, 0, ((String[])object).length);
        switch (c) {
            case 'c': {
                Command.archive(file, (String[])object, bl);
                break;
            }
            case 't': {
                Command.list(file, (String[])object, bl);
                break;
            }
            case 'x': {
                Command.expand(file, (String[])object, bl);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void archive(File file, String[] stringArray, boolean bl) throws IOException {
        ArchiveType archiveType = ArchiveType.getType(file);
        if (archiveType == ArchiveType.UNKNOWN) {
            throw new IllegalArgumentException("invalid file suffix: " + file.getName());
        }
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = new File(stringArray[i]);
            if (!file2.isDirectory() && !file2.canRead()) {
                throw new IOException("invalid target: " + file2);
            }
            fileArray[i] = file2;
        }
        FileArchiver fileArchiver = new FileArchiver(file, archiveType);
        try {
            fileArchiver.setVerbose(bl);
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                fileArchiver.archive(file3);
            }
        }
        finally {
            fileArchiver.close();
        }
        if (bl) {
            System.out.println("finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void list(File file, String[] stringArray, boolean bl) throws IOException {
        FileExpander fileExpander = new FileExpander(file);
        try {
            fileExpander.setVerbose(bl);
            if (stringArray.length > 0) {
                fileExpander.list(stringArray);
            } else {
                fileExpander.list();
            }
        }
        finally {
            fileExpander.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(File file, String[] stringArray, boolean bl) throws IOException {
        FileExpander fileExpander = new FileExpander(file);
        try {
            fileExpander.setVerbose(bl);
            File file2 = new File(".");
            if (stringArray.length > 0) {
                fileExpander.expand(file2, stringArray);
            } else {
                fileExpander.expand(file2);
            }
        }
        finally {
            fileExpander.close();
        }
    }

    private static void printUsage() {
        System.out.println("usage: arm [ctx][v][f] archive-file target [target...]");
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            if (stringArray.length < 1 || stringArray[0].equals("-h") || stringArray[0].equals("--help")) {
                System.out.println("armadillo - archiving utility");
                System.out.println(Version.getVersionString(true));
                Command.printUsage();
            } else {
                Command.execute(stringArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("armadillo: parameter error - " + illegalArgumentException.getMessage());
            Command.printUsage();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("armadillo: I/O error - " + iOException.getMessage());
            String string = "jp.sourceforge.armadillo.debug";
            if (!System.getProperty(string, "false").equalsIgnoreCase("false")) {
                throw iOException;
            }
            System.exit(1);
        }
    }

    static {
        $assertionsDisabled = !Command.class.desiredAssertionStatus();
    }
}

