/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;

public final class ArchiveType {
    public static final ArchiveType ZIP = new ArchiveType("ZIP");
    public static final ArchiveType TAR = new ArchiveType("TAR");
    public static final ArchiveType TGZ = new ArchiveType("TGZ");
    public static final ArchiveType TBZ = new ArchiveType("TBZ");
    public static final ArchiveType LZH = new ArchiveType("LZH");
    public static final ArchiveType UNKNOWN = new ArchiveType("UNKNOWN");
    private final String typeName;

    private ArchiveType(String string) {
        this.typeName = string;
    }

    static ArchiveType getType(File file) {
        if (!file.isDirectory()) {
            String string = file.getName().toLowerCase();
            if (string.endsWith(".zip")) {
                return ZIP;
            }
            if (string.endsWith(".tar")) {
                return TAR;
            }
            if (string.endsWith(".tar.gz") || string.endsWith(".tgz")) {
                return TGZ;
            }
            if (string.endsWith(".tar.bz2") || string.endsWith(".tbz")) {
                return TBZ;
            }
            if (string.endsWith(".lzh")) {
                return LZH;
            }
        }
        return UNKNOWN;
    }

    public String toString() {
        return "ArchiveType:" + this.typeName;
    }
}

