package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * o̓[eBeBB
 */
public final class IOUtilities {

    private static final int BUFFER_SIZE = 8192;

    /**
     * IOUtilities̐B
     */
    private IOUtilities() {
        // empty
    }

    /**
     * t@CړB
     * @param src ړt@C
     * @param dst ړt@C
     * @param overwrite ㏑ꍇ <code>true</code> A
     *                  ㏑Ȃꍇ <code>false</code>
     * @return t@C̈ړɐꍇ <code>true</code> A
     *                         sꍇ <code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    public static boolean move(File src, File dst, boolean overwrite) throws IOException {
        if (dst.exists()) {
            if (overwrite) {
                dst.delete();
            } else {
                throw new IOException("file already exists: " + dst);
            }
        }
        mkdirsIfNotExists(dst);
        return src.renameTo(dst);
    }

    /**
     * t@CRs[B
     * @param src Rs[t@C
     * @param dst Rs[t@C
     * @param overwrite ㏑ꍇ <code>true</code> A
     *                  ㏑Ȃꍇ <code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(File src, File dst, boolean overwrite) throws IOException {
        if (dst.exists()) {
            if (!overwrite) {
                throw new IOException("file already exists: " + dst);
            }
        }
        copy(src, dst);
    }

    /**
     * t@CRs[B
     * @param src Rs[t@C
     * @param dst Rs[t@C
     * @return Rs[ꂽf[^̃TCY
     * @throws IOException o̓G[ꍇ
     */
    public static long copy(File src, File dst) throws IOException {
        long modifiedTime = src.lastModified();
        mkdirsIfNotExists(dst);
        FileOutputStream fos = new FileOutputStream(dst);
        try {
            FileInputStream fis = new FileInputStream(src);
            try {
                //                long size = transferAll(fis, fos);
                long size = fis.getChannel().transferTo(0L, src.length(), fos.getChannel());
                dst.setLastModified(modifiedTime);
                return size;
            } finally {
                fis.close();
            }
        } finally {
            fos.close();
        }
    }

    /**
     * Xg[f[^]B
     * @param is ]̓Xg[
     * @param os ]o̓Xg[
     * @param length ]f[^
     * @return ]ꂽf[^̃TCY
     * @throws IOException o̓G[ꍇ
     */
    public static long transfer(InputStream is, OutputStream os, long length) throws IOException {
        long rest = length;
        long totalSize = 0;
        int bufferSize = IOUtilities.BUFFER_SIZE;
        byte[] buffer = new byte[bufferSize];
        while (rest > 0) {
            int requestLength = (int)Math.min(rest, bufferSize);
            int readLength = is.read(buffer, 0, requestLength);
            if (readLength < 0) {
                break;
            }
            os.write(buffer, 0, readLength);
            rest -= readLength;
            totalSize += readLength;
        }
        os.flush();
        return totalSize;
    }

    /**
     * Xg[f[^Sē]B
     * @param is ]̓Xg[
     * @param os ]o̓Xg[
     * @return ]ꂽf[^̃TCY
     * @throws IOException o̓G[ꍇ
     */
    public static long transferAll(InputStream is, OutputStream os) throws IOException {
        long totalSize = 0;
        byte[] buffer = new byte[BUFFER_SIZE];
        for (int readLength; (readLength = is.read(buffer)) >= 0;) {
            os.write(buffer, 0, readLength);
            totalSize += readLength;
        }
        os.flush();
        return totalSize;
    }

    /**
     * t@C̃fBNg݂Ȃꍇɍ쐬B
     * @param file t@C
     * @throws IOException o̓G[ꍇ 
     */
    private static void mkdirsIfNotExists(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            if (!parent.mkdirs()) {
                throw new IOException("failed to mkdir: " + parent);
            }
        }
    }

}
