package jp.sourceforge.armadillo.lzh;

/**
 * nt}e[uB
 */
class HuffmanTableBuilder {

    private int[] codeTable;
    private int[] codeLengthTable;

    /**
     * HuffmanTableBuilder̐B
     */
    HuffmanTableBuilder() {
        // empty
    }

    /**
     * e[u̍\zB
     * @param frequencyTable px\
     */
    void build(int[] frequencyTable) {
        int tableSize = frequencyTable.length;
        while (tableSize > 0 && frequencyTable[tableSize - 1] == 0) {
            --tableSize;
        }
        int[] heap = new int[tableSize + 1000];
        int heapSize = 0;
        for (int i = 0; i < tableSize; i++) {
            if (frequencyTable[i] > 0) {
                heap[++heapSize] = i;
            }
        }
        if (heapSize <= 1) {
            int[] ct = new int[tableSize];
            int[] lt = new int[tableSize];
            if (heapSize == 1) {
                ct[tableSize - 1] = 1;
            }
            this.codeTable = ct;
            this.codeLengthTable = lt;
            return;
        }
        // p-queue
        for (int i = heapSize / 2; i >= 1; i--) {
            downheap(i, heap, heapSize, frequencyTable);
        }

        int capacity = frequencyTable.length * 2;
        int[] lNodes = new int[capacity];
        int[] rNodes = new int[capacity];
        int[] weight = new int[capacity];
        int[] symbols = new int[tableSize];
        int symbolP = 0;
        System.arraycopy(frequencyTable, 0, weight, 0, tableSize);
        int x = frequencyTable.length;
        while (heapSize > 1) {
            int left = heap[1];
            if (left < tableSize) {
                symbols[symbolP++] = left;
            }
            heap[1] = heap[heapSize--];
            downheap(1, heap, heapSize, weight);
            int right = heap[1];
            if (right < tableSize) {
                symbols[symbolP++] = right;
            }
            int node = x++;
            weight[node] = weight[left] + weight[right];
            heap[1] = node;
            downheap(1, heap, heapSize, weight);
            lNodes[node] = left;
            rNodes[node] = right;
        }
        int[] lt = new int[tableSize];
        createCodeLengthTable(heap[1], lNodes, rNodes, symbols, lt);
        int[] depths = new int[1024];
        countDepth(heap[1], 0, lNodes, rNodes, depths);
        int[] ct = createCodeTable(lt, depths);
        this.codeTable = ct;
        this.codeLengthTable = lt;
    }

    /**
     * @param index
     * @param heap
     * @param heapSize
     * @param weight
     */
    private static void downheap(int index, int[] heap, int heapSize, int[] weight) {
        int i = index;
        int j = 0;
        int node = heap[i];
        while ((j = 2 * i) <= heapSize) {
            if (j < heapSize && weight[heap[j]] > weight[heap[j + 1]]) {
                ++j;
            }
            if (weight[node] <= weight[heap[j]]) {
                break;
            }
            heap[i] = heap[j];
            i = j;
        }
        heap[i] = node;
    }

    /**
     * @param rootNode
     * @param leftNodes
     * @param rightNodes
     * @param symbols
     * @param lt
     */
    private static void createCodeLengthTable(int rootNode,
                                              int[] leftNodes,
                                              int[] rightNodes,
                                              int[] symbols,
                                              int[] lt) {
        int[] depths = new int[1024];
        countDepth(rootNode, 0, leftNodes, rightNodes, depths);
        int p = 0;
        for (int i = 16; i > 0; i--) {
            int depth = depths[i];
            while (depth > 0) {
                lt[symbols[p++]] = i;
                --depth;
            }
        }
    }

    /**
     * m[h̐[xWvB
     * @param node
     * @param depth
     * @param leftNodes
     * @param rightNodes
     * @param counts
     */
    private static void countDepth(int node,
                                   int depth,
                                   int[] leftNodes,
                                   int[] rightNodes,
                                   int[] counts) {
        if (node < 512) {
            ++counts[depth];
        } else {
            countDepth(leftNodes[node], depth + 1, leftNodes, rightNodes, counts);
            countDepth(rightNodes[node], depth + 1, leftNodes, rightNodes, counts);
        }
    }

    /**
     * e[u𐶐B
     * @param lengthList Xg
     * @param depths őrbg
     * @param codeList Xg
     * @return e[u
     */
    private static int[] createCodeTable(int[] lengthList, int[] depths) {
        int listSize = lengthList.length;
        int[] ct = new int[listSize];
        int[] start = new int[WORK_TABLE_BITLENGTH];
        int j = 0;
        int k = 0x8000;
        for (int i = 1; i < WORK_TABLE_BITLENGTH; i++) {
            start[i] = j >>> (16 - i);
            j += k * depths[i];
            k >>= 1;
        }
        for (int i = 0; i < lengthList.length; i++) {
            int cl = lengthList[i];
            if (cl > 0) {
                ct[i] = start[cl];
                ++start[cl];
            }
        }
        return ct;
    }

    /**
     * Xgp[Ne[ũTCY (16bits + ԕ)
     */
    private static final int WORK_TABLE_BITLENGTH = 16 + 1;

    /**
     * Xg𐶐B
     * @param lengthList Xg
     * @return Xg
     */
    static int[] createCodeList(short[] lengthList) {
        int[] counts = new int[WORK_TABLE_BITLENGTH];
        for (int i = 0; i < lengthList.length; i++) {
            ++counts[lengthList[i]];
        }
        int[] baseCodes = new int[WORK_TABLE_BITLENGTH];
        for (int i = 0; i < WORK_TABLE_BITLENGTH - 1; i++) { // i = bit length - 1
            baseCodes[i + 1] = baseCodes[i] + counts[i + 1] << 1;
        }
        assert baseCodes[WORK_TABLE_BITLENGTH - 1] == 1 << WORK_TABLE_BITLENGTH : baseCodes[WORK_TABLE_BITLENGTH - 1];
        int[] codeList = new int[lengthList.length];
        for (int i = 0; i < codeList.length; i++) {
            int codeLength = lengthList[i];
            if (codeLength > 0) {
                codeList[i] = baseCodes[codeLength - 1]++;
            }
        }
        return codeList;
    }

    /**
     * codeTable̎擾B
     * @return codeTable
     */
    int[] getCodeTable() {
        return codeTable;
    }

    /**
     * codeLengthTable̎擾B
     * @return codeLengthTable
     */
    int[] getCodeLengthTable() {
        return codeLengthTable;
    }

}
