package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * A[JCu̓̓Xg[B
 */
public abstract class ArchiveInputStream extends FilterInputStream {

    protected InputStream frontStream;
    protected long remaining;

    private boolean closed;

    /**
     * ArchiveInputStream̐B
     * @param is InputStream
     */
    public ArchiveInputStream(InputStream is) {
        super(is);
        this.closed = false;
        this.remaining = 0;
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    protected final void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream closed");
        }
    }

    /* (overridden)
     * @see java.io.InputStream#read()
     */
    public int read() throws IOException {
        ensureOpen();
        if (remaining <= 0) {
            return -1;
        }
        InputStream is = (frontStream == null) ? in : frontStream;
        int read = is.read();
        if (read == -1) {
            return -1;
        }
        --remaining;
        return read;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#read(byte[], int, int)
     */
    public int read(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        if (remaining < 1) {
            assert remaining == 0;
            return -1;
        }
        InputStream is = (frontStream == null) ? in : frontStream;
        int readLength = is.read(b, off, (int)Math.min(len, remaining));
        if (readLength >= 0) {
            remaining -= readLength;
        }
        return readLength;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#skip(long)
     */
    public long skip(long n) throws IOException {
        ensureOpen();
        long skipped;
        InputStream is = (frontStream == null) ? in : frontStream;
        skipped = is.skip(n);
        if (skipped > 0) {
            remaining -= skipped;
        }
        return skipped;
    }

    /* (overridden)
     * @see java.io.InputStream#available()
     */
    public int available() throws IOException {
        return 0;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#markSupported()
     */
    public boolean markSupported() {
        return false;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#mark(int)
     */
    public synchronized void mark(int limit) {
        // not supported
    }

    /* (overridden)
     * @see java.io.FilterInputStream#reset()
     */
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /* (overridden)
     * @see java.io.InputStream#close()
     */
    public void close() throws IOException {
        closed = true;
        try {
            super.close();
        } finally {
            frontStream = null;
        }
    }

}
