package jp.sourceforge.armadillo;

import java.io.*;

/**
 * Ƀ^CvB
 */
public final class ArchiveType {

    /**
     * <code>ZIP</code>
     */
    public static final ArchiveType ZIP = new ArchiveType("ZIP");

    /**
     * <code>TAR</code>
     */
    public static final ArchiveType TAR = new ArchiveType("TAR");

    /**
     * <code>TGZ (TAR+GZIP)</code>
     */
    public static final ArchiveType TGZ = new ArchiveType("TGZ");

    /**
     * <code>TBZ (TAR+BZIP2)</code>
     */
    public static final ArchiveType TBZ = new ArchiveType("TBZ");

    /**
     * <code>LZH</code>
     */
    public static final ArchiveType LZH = new ArchiveType("LZH");

    /**
     * sȃ^CvB
     */
    public static final ArchiveType UNKNOWN = new ArchiveType("UNKNOWN");

    private final String typeName;

    /**
     * ArchiveType̐B
     * @param typeName ^Cv 
     */
    private ArchiveType(String typeName) {
        this.typeName = typeName;
    }

    /**
     * ^Cv̎擾B
     * @param file t@C
     * @return ^Cv
     */
    static ArchiveType getType(File file) {
        if (!file.isDirectory()) {
            String nameLC = file.getName().toLowerCase();
            if (nameLC.endsWith(".zip")) {
                return ZIP;
            }
            if (nameLC.endsWith(".tar")) {
                return TAR;
            }
            if (nameLC.endsWith(".tar.gz") || nameLC.endsWith(".tgz")) {
                return TGZ;
            }
            if (nameLC.endsWith(".tar.bz2") || nameLC.endsWith(".tbz")) {
                return TBZ;
            }
            if (nameLC.endsWith(".lzh")) {
                return LZH;
            }
        }
        return UNKNOWN;
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "ArchiveType:" + typeName;
    }

}
