/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import jp.sourceforge.armadillo.lzh.LzhException;

public final class LzhMethod {
    public static final String LHD = "-lhd-";
    public static final String LH0 = "-lh0-";
    public static final String LH4 = "-lh4-";
    public static final String LH5 = "-lh5-";
    public static final String LH6 = "-lh6-";
    public static final String LH7 = "-lh7-";
    private final String methodName;
    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;

    public LzhMethod(String string) throws LzhException {
        this.methodName = string;
        if (string.matches("-lh[d0]-")) {
            this.dictionarySize = 0;
            this.matchSize = 0;
            this.threshold = 0;
        } else if (string.matches("-lh[4567]-")) {
            switch (string.charAt(3)) {
                case '4': {
                    this.dictionarySize = 4096;
                    break;
                }
                case '5': {
                    this.dictionarySize = 8192;
                    break;
                }
                case '6': {
                    this.dictionarySize = 32768;
                    break;
                }
                case '7': {
                    this.dictionarySize = 65536;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.matchSize = 256;
            this.threshold = 3;
        } else {
            throw new LzhException("unsupported method: " + string);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public int getMatchSize() {
        return this.matchSize;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isCompressing() {
        return this.dictionarySize == 0;
    }
}

