/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

class HuffmanTableBuilder {
    private int[] codeTable;
    private int[] codeLengthTable;
    private static final int WORK_TABLE_BITLENGTH = 17;
    static final /* synthetic */ boolean $assertionsDisabled;

    HuffmanTableBuilder() {
    }

    void build(int[] nArray) {
        int n;
        int n2;
        for (n2 = nArray.length; n2 > 0 && nArray[n2 - 1] == 0; --n2) {
        }
        int[] nArray2 = new int[n2 + 1000];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] <= 0) continue;
            nArray2[++n3] = n;
        }
        if (n3 <= 1) {
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            if (n3 == 1) {
                nArray3[n2 - 1] = 1;
            }
            this.codeTable = nArray3;
            this.codeLengthTable = nArray4;
            return;
        }
        for (n = n3 / 2; n >= 1; --n) {
            HuffmanTableBuilder.downheap(n, nArray2, n3, nArray);
        }
        n = nArray.length * 2;
        int[] nArray5 = new int[n];
        int[] nArray6 = new int[n];
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n2];
        int n4 = 0;
        System.arraycopy(nArray, 0, nArray7, 0, n2);
        int n5 = nArray.length;
        while (n3 > 1) {
            int n6 = nArray2[1];
            if (n6 < n2) {
                nArray8[n4++] = n6;
            }
            nArray2[1] = nArray2[n3--];
            HuffmanTableBuilder.downheap(1, nArray2, n3, nArray7);
            int n7 = nArray2[1];
            if (n7 < n2) {
                nArray8[n4++] = n7;
            }
            int n8 = n5++;
            nArray7[n8] = nArray7[n6] + nArray7[n7];
            nArray2[1] = n8;
            HuffmanTableBuilder.downheap(1, nArray2, n3, nArray7);
            nArray5[n8] = n6;
            nArray6[n8] = n7;
        }
        int[] nArray9 = new int[n2];
        HuffmanTableBuilder.createCodeLengthTable(nArray2[1], nArray5, nArray6, nArray8, nArray9);
        int[] nArray10 = new int[1024];
        HuffmanTableBuilder.countDepth(nArray2[1], 0, nArray5, nArray6, nArray10);
        int[] nArray11 = HuffmanTableBuilder.createCodeTable(nArray9, nArray10);
        this.codeTable = nArray11;
        this.codeLengthTable = nArray9;
    }

    private static void downheap(int n, int[] nArray, int n2, int[] nArray2) {
        int n3 = n;
        int n4 = 0;
        int n5 = nArray[n3];
        while ((n4 = 2 * n3) <= n2) {
            if (n4 < n2 && nArray2[nArray[n4]] > nArray2[nArray[n4 + 1]]) {
                ++n4;
            }
            if (nArray2[n5] <= nArray2[nArray[n4]]) break;
            nArray[n3] = nArray[n4];
            n3 = n4;
        }
        nArray[n3] = n5;
    }

    private static void createCodeLengthTable(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[1024];
        HuffmanTableBuilder.countDepth(n, 0, nArray, nArray2, nArray5);
        int n2 = 0;
        for (int i = 16; i > 0; --i) {
            for (int j = nArray5[i]; j > 0; --j) {
                nArray4[nArray3[n2++]] = i;
            }
        }
    }

    private static void countDepth(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (n < 512) {
            int n3 = n2;
            nArray3[n3] = nArray3[n3] + 1;
        } else {
            HuffmanTableBuilder.countDepth(nArray[n], n2 + 1, nArray, nArray2, nArray3);
            HuffmanTableBuilder.countDepth(nArray2[n], n2 + 1, nArray, nArray2, nArray3);
        }
    }

    private static int[] createCodeTable(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[17];
        int n3 = 0;
        int n4 = 32768;
        for (n = 1; n < 17; ++n) {
            nArray4[n] = n3 >>> 16 - n;
            n3 += n4 * nArray2[n];
            n4 >>= 1;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n5 = nArray[n];
            if (n5 <= 0) continue;
            nArray3[n] = nArray4[n5];
            int n6 = n5;
            nArray4[n6] = nArray4[n6] + 1;
        }
        return nArray3;
    }

    static int[] createCodeList(short[] sArray) {
        int[] nArray = new int[17];
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            nArray[s] = nArray[s] + 1;
        }
        int[] nArray2 = new int[17];
        for (int i = 0; i < 16; ++i) {
            nArray2[i + 1] = nArray2[i] + nArray[i + 1] << 1;
        }
        if (!$assertionsDisabled && nArray2[16] != 131072) {
            throw new AssertionError(nArray2[16]);
        }
        int[] nArray3 = new int[sArray.length];
        for (int i = 0; i < nArray3.length; ++i) {
            short s = sArray[i];
            if (s <= 0) continue;
            int n = s - 1;
            nArray2[n] = nArray2[n] + 1;
        }
        return nArray3;
    }

    int[] getCodeTable() {
        return this.codeTable;
    }

    int[] getCodeLengthTable() {
        return this.codeLengthTable;
    }

    static {
        $assertionsDisabled = !HuffmanTableBuilder.class.desiredAssertionStatus();
    }
}

