/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.ArchiveType;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.LzhArchiver;
import jp.sourceforge.armadillo.TarArchiver;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.ZipArchiver;

public final class FileArchiver {
    private Archiver archiver;
    private PrintWriter out;
    private boolean verbose;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileArchiver(File file) throws IOException {
        this(file, ArchiveType.getType(file));
    }

    public FileArchiver(File file, ArchiveType archiveType) throws IOException {
        if (file.exists()) {
            throw new IOException("file already exists");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (archiveType == ArchiveType.TAR) {
            this.archiver = new TarArchiver(fileOutputStream);
        } else if (archiveType == ArchiveType.TGZ) {
            this.archiver = new TarArchiver(new GZIPOutputStream(fileOutputStream));
        } else if (archiveType == ArchiveType.ZIP) {
            this.archiver = new ZipArchiver(fileOutputStream);
        } else if (archiveType == ArchiveType.LZH) {
            this.archiver = new LzhArchiver(fileOutputStream);
        } else {
            throw new IllegalStateException("ArchiverType: " + archiveType);
        }
        this.out = Utilities.getDefaultPrintWriter();
    }

    public void setOut(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("out is null");
        }
        this.out = printWriter;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void archive(File file) throws IOException {
        this.archive(file, FileArchiver.getRootPath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archive(File file, String string) throws IOException {
        File[] fileArray;
        boolean bl = file.isDirectory();
        String string2 = FileArchiver.getEntryName(file, string, bl);
        ArchiveEntry archiveEntry = new ArchiveEntry(string2);
        archiveEntry.setLastModified(file.lastModified());
        if (bl) {
            this.archiver.addEntry(archiveEntry, null, 0L);
            fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                this.archive(fileArray[i], string);
            }
        } else {
            fileArray = new FileInputStream(file);
            try {
                this.archiver.addEntry(archiveEntry, (InputStream)fileArray, file.length());
            }
            finally {
                fileArray.close();
            }
        }
        if (!archiveEntry.isAdded()) {
            return;
        }
        if (this.verbose) {
            long l = archiveEntry.getSize();
            long l2 = archiveEntry.getCompressedSize();
            if (!($assertionsDisabled || l2 >= 0L && l >= 0L)) {
                throw new AssertionError();
            }
            this.out.print("appending  " + file);
            if (l2 == l) {
                this.out.print(" (STORED)");
            } else {
                int n = l2 == l ? 100 : (int)(l2 * 100L / l);
                this.out.print(" (" + n + "%, " + l + " => " + l2 + ")");
            }
            this.out.println();
        }
    }

    private static String getRootPath(File file) {
        String string = FileArchiver.normalizePath(file.getAbsoluteFile().getParent());
        if (!string.endsWith(String.valueOf('/'))) {
            string = string + '/';
        }
        return string;
    }

    private static String getEntryName(File file, String string, boolean bl) {
        String string2;
        String string3 = FileArchiver.normalizePath(file.getAbsolutePath());
        if (string3.startsWith(string)) {
            string2 = string3.substring(string.length());
            if (file.isDirectory() && !string2.endsWith(String.valueOf('/'))) {
                string2 = string2 + '/';
            }
        } else {
            string2 = file.getName();
        }
        return string2;
    }

    private static String normalizePath(String string) {
        return string.replace('\\', '/');
    }

    public void close() throws IOException {
        this.archiver.close();
    }

    static {
        $assertionsDisabled = !FileArchiver.class.desiredAssertionStatus();
    }
}

