/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_DISK_WRITER_H_
#define _D_DISK_WRITER_H_

#include "BinaryStream.h"

namespace aria2 {

/**
 * Interface for writing to a binary stream of bytes.
 *
 */
class DiskWriter:public BinaryStream {
public:
  DiskWriter() {}

  virtual ~DiskWriter() {}
  /**
   * Opens file. If the file exists, then it is truncated to 0 length.
   */
  virtual void initAndOpenFile(uint64_t totalLength = 0)  = 0;
  
  virtual void openFile(uint64_t totalLength = 0) = 0;

  /**
   * Closes this output stream.
   */
  // TODO we have to examine the return value of close()
  virtual void closeFile() = 0;

  /**
   * Opens a file.  If the file doesnot exists, an exception may be
   * thrown.
   */
  virtual void openExistingFile(uint64_t totalLength = 0) = 0;

  // Returns file length
  virtual uint64_t size() = 0;

  virtual void enableDirectIO() = 0;

  virtual void disableDirectIO() = 0;

  virtual void allowDirectIO() {}

  // Enables read-only mode. After this call, openExistingFile() opens
  // file in read-only mode. This is an optional functionality. The
  // default implementation is do nothing.
  virtual void enableReadOnly() {}

  // Disables read-only mode. After this call, openExistingFile()
  // opens file in read/write mode. This is an optional
  // functionality. The default implementation is do noting.
  virtual void disableReadOnly() {}
};

typedef SharedHandle<DiskWriter> DiskWriterHandle;

} // namespace aria2

#endif // _D_DISK_WRITER_H_
