﻿using System;
using System.Threading;
using NUnit.Framework;

using NaGet.SubCommands.SubTask;

namespace test_na_get_lib
{
	[TestFixture]
	public class NaGetSubTaskTest
	{
		[Test]
		public void Running()
		{
			ASubTaskForTest subtask = new ASubTaskForTest();
			Assert.IsFalse(subtask.Running);
			subtask.CallNotifyStarted();
			Assert.IsTrue(subtask.Running);
			subtask.CallNotifyCompleted();
			Assert.IsFalse(subtask.Running);
			
			subtask = new ASubTaskForTest();
			Assert.IsFalse(subtask.Running);
			subtask.CallNotifyStarted();
			Assert.IsTrue(subtask.Running);
			subtask.CallNotifyCancelled();
			Assert.IsFalse(subtask.Running);
		}
		
		[Test]
		public void Cancelled()
		{
			ASubTaskForTest subtask = new ASubTaskForTest();
			Assert.IsFalse(subtask.Cancelled);
			subtask.CallNotifyStarted();
			Assert.IsFalse(subtask.Cancelled);
			subtask.CallNotifyCancelled();
			Assert.IsTrue(subtask.Cancelled);
			Assert.IsTrue(subtask.Done);
		}
		
		[Test]
		public void Done()
		{
			ASubTaskForTest subtask = new ASubTaskForTest();
			subtask.CallNotifyStarted();
			Assert.IsFalse(subtask.Done);
			subtask.CallNotifyCompleted();
			Assert.IsTrue(subtask.Done);
		}
		
		[Test]
		public void UseProgress()
		{
			ASubTaskForTest subtask = new ASubTaskForTest();
			Assert.IsTrue(subtask.UseProgress);
		}
		
		[Test]
		public void Run()
		{
			ASubTaskForTest subtask = new ASubTaskForTest();
			Assert.IsFalse(subtask.Running);
			Assert.IsFalse(subtask.Done);
			subtask.Run();
			Assert.IsFalse(subtask.Running);
			Assert.IsTrue(subtask.Done);
		}
		
		#region テスト用派生クラス
		
		private class ASubTaskForTest : NaGetSubTask
		{
			public override void Run()
			{
				NotifyStarted();
				Thread.Sleep(1);
				NotifyCompleted();
			}
			
			public void CallNotifyStarted()
			{
				NotifyStarted();
			}
			
			public void CallNotifyCompleted()
			{
				NotifyCompleted();
			}
			
			public void CallNotifyCancelled()
			{
				NotifyCancelled();
			}
		}
		
		#endregion
		
	}
	
}
