﻿using System;
using NaGet.Tasks;
using NaGet.Packages;

namespace NaGet.SubCommands.SubTask
{
	public class LocalUpdateSubTask : NaGetSubTask
	{
		private PackageListsManager pkgListMan;
		
		public LocalUpdateSubTask(PackageListsManager pkgListMan)
		{
			this.pkgListMan = pkgListMan;
		}
		
		public override void Run()
		{
			NotifyStarted();
			RaiseTaskSetEvent(TaskEventType.STARTED, "インストール済みファイルリスト更新", 0);
			
			pkgListMan.DetectInstalledPkgs();
			pkgListMan.SaveInstalledPackageList();
			RaiseTaskSetEvent(TaskEventType.INFO, string.Format("{0} を更新しました", NaGet.Env.ArchiveInstalledPackageListFile), 50);
			
			pkgListMan.DetectSystemInstalledPkgs();
			pkgListMan.SaveSystemInstalledPackageList();
			RaiseTaskSetEvent(TaskEventType.INFO, string.Format("{0} を更新しました", NaGet.Env.SystemInstalledPackageListFile), 100);
			
			RaiseTaskSetEvent(TaskEventType.COMPLETED, "インストール済みファイルリスト更新", 100);
			NotifyCompleted();
		}
	}
}
