using System;

namespace NaGet.SubCommands
{
	#region EventHandler<NaGetTaskSetEventArgs>֘A
	
	public class NaGetTaskSetEventArgs : NaGetEventArgs
	{
		public NaGetTaskSetEventType Type;
		
		public NaGetTaskSetEventArgs(NaGetTaskSetEventType type, string message, float processPercent)
		{
			this.Type = type;
			this.TaskMessage = message;
			this.TaskProgressPercent = processPercent;
		}
	}
	
	/// <summary>
	/// ^XN̎
	/// </summary>
	public enum NaGetTaskSetEventType
	{
		/// <summary>
		/// Jn
		/// </summary>
		STARTED,
		/// <summary>
		/// (ׂĂ)
		/// </summary>
		COMPLETED,
		/// <summary>
		/// ƂLZꂽ
		/// </summary>
		CANCELED,
		/// <summary>
		/// G[𔭐(f)
		/// </summary>
		ERROR,
		/// <summary>
		/// G[p
		/// </summary>
		WARNING,
		/// <summary>
		/// ̂ق̏
		/// </summary>
		INFO,
		/// <summary>
		/// ƂJn
		/// </summary>
		STARTED_TASKSET,
		/// <summary>
		/// ƂI
		/// </summary>
		COMPLETED_TASKSET,
		/// <summary>
		/// iEʒm̂
		/// </summary>
		PING,
	}
	
	#endregion
	
	#region NaGetTaskQueryHandler֘A
	
	public delegate NaGetTaskQueryResult NaGetTaskQueryHandler(object sender, NaGetTaskQueryArgs e);
	
	public class NaGetTaskQueryArgs
	{
		/// <summary>
		/// ^XŇ̃bZ[W
		/// </summary>
		public string Message;
		
		/// <summary>
		/// 񓚂̎ނ̃tO
		/// </summary>
		public NaGetTaskQueryResult SelectionFlag;
		
		public NaGetTaskQueryArgs(string message, NaGetTaskQueryResult selectionFlag)
		{
			this.Message = message;
			this.SelectionFlag = selectionFlag;
		}
	}
	
	/// <summary>
	/// ̓
	/// </summary>
	[Flags()]
	public enum NaGetTaskQueryResult : uint
	{
		/// <summary>
		/// p(=OK)
		/// </summary>
		CONTINUE = 0x01,
		/// <summary>
		/// Ďs
		/// </summary>
		RETRY = 0x02,
		/// <summary>
		/// LZA~
		/// </summary>
		CANCEL = 0x04,
		/// <summary>
		/// IȃLZ([U̎ł͂Ȃ)
		/// </summary>
		CANCELED_AUTOMATICALLY = 0x00,
	}
	
	
	#endregion
	
	/// <summary>
	/// NaGet^XÑpbN
	/// </summary>
	public abstract class NaGetTaskSet : NaGetTask
	{
		/// <summary>
		/// ^XÑCxgnh
		/// </summary>
		public event EventHandler<NaGetTaskSetEventArgs> TaskSetRaised;
		
		/// <summary>
		/// ^XN̎̃nh
		/// </summary>
		public event NaGetTaskQueryHandler TaskQueryRaised;
		
		/// <summary>
		/// ŕ\ƈꗗXg
		/// </summary>
		public string[] TaskSetNames;
		
		/// <summary>
		/// ݎs̍Ɣԍ
		/// </summary>
		public abstract int CurrentTaskSetIndex {
			get;
		}
		
		/// <summary>
		/// ݂̐i߂B
		/// </summary>
		/// <param name="type">Ƃ̏</param>
		/// <param name="subTaskProgress">Tu^XN̐i</param>
		/// <returns>݂̐i</returns>
		protected virtual float GetProgressPercent(NaGetTaskSetEventType type, float subTaskProgress)
		{
			if (CurrentTaskSetIndex >= 0) {
				if (subTaskProgress >= 0) {
					return (CurrentTaskSetIndex * 100 + subTaskProgress) / TaskSetNames.Length;
				}
				switch (type) {
					case NaGetTaskSetEventType.STARTED:
						return 0;
					case NaGetTaskSetEventType.COMPLETED:
						return 100;
					case NaGetTaskSetEventType.COMPLETED_TASKSET:
						return ((CurrentTaskSetIndex+1) * 100) / TaskSetNames.Length;
					default:
						return (CurrentTaskSetIndex * 100) / TaskSetNames.Length;
				}
			}
			
			return -1;
		}
		
		protected virtual void RaiseTaskSetEvent(NaGetTaskSetEventType type, string message)
		{
			RaiseTaskSetEvent(type, message, GetProgressPercent(type, -1));
		}
		
		protected virtual void RaiseTaskSetEvent(NaGetTaskSetEventType type, string message, float percent)
		{
			if (TaskSetRaised != null) {
				TaskSetRaised(this, new NaGetTaskSetEventArgs(type, message, percent));
			}
		}
		
		protected virtual void ReceivedErrorData(object sender, NaGet.Utils.AnyDataEventArgs<string> e)
		{
			if (! string.IsNullOrEmpty(e.Data)) {
				RaiseTaskSetEvent(NaGetTaskSetEventType.WARNING, e.Data);
			}
		}
		
		protected virtual void ReceivedOutputData(object sender, NaGet.Utils.AnyDataEventArgs<string> e)
		{
			if (! string.IsNullOrEmpty(e.Data)) {
				RaiseTaskSetEvent(NaGetTaskSetEventType.INFO, e.Data);
			}
		}
		
		protected virtual NaGetTaskQueryResult RaiseTaskSetQueryEvent(string message, NaGetTaskQueryResult selection)
		{
			if (TaskQueryRaised != null) {
				return TaskQueryRaised(this, new NaGetTaskQueryArgs(message, selection));
			}
			return NaGetTaskQueryResult.CANCELED_AUTOMATICALLY;
		}
		
		public override bool Running {
			get { return CurrentTaskSetIndex >= 0 && !Done; }
		}
	}
}
