using System;
using NaGet.Packages.Install;
using NaGet.Packages;
using NaGet.Net;

namespace NaGet.SubCommands
{
	public class NaGetUninstall : NaGetTaskSet
	{
		private bool done = false;
		
		private int currentTaskSetIndex = -1;
		
		private PackageListsManager pkgListMan;
		
		/// <summary>
		/// ACXg[pbP[W
		/// </summary>
		public Uninstallation[] Uninstallations;
		
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="pkgs">ACXg[pbP[W</param>
		public NaGetUninstall(PackageListsManager pkgMan, InstalledPackage[] pkgs)
		{
			pkgListMan = pkgMan;
			
			Uninstallations = new Uninstallation[pkgs.Length];
			for (int i = 0; i < pkgs.Length; i++) {
				Uninstallations[i] = new Uninstallation(pkgs[i]);
			}
			
			initializeMainTaskSetNames();
		}
		
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="uninstallations">ACXg[̔z</param>
		public NaGetUninstall(PackageListsManager pkgMan, Uninstallation[] uninstallations)
		{
			pkgListMan = pkgMan;
			
			Uninstallations = uninstallations;
			initializeMainTaskSetNames();
		}
		
		private void initializeMainTaskSetNames()
		{
			System.Collections.Generic.List<string> taskSetNames = new System.Collections.Generic.List<string>();
			
			for (int i =0; i < Uninstallations.Length; i++) {
				taskSetNames.Add(string.Format("ACXg[: {0}", Uninstallations[i].ToString()));
			}
			taskSetNames.Add(string.Format("XgXV: {0}", NaGet.Env.ArchiveInstalledPackageListFile));
			taskSetNames.Add(string.Format("XgXV: {0}", NaGet.Env.SystemInstalledPackageListFile));
			
			TaskSetNames = taskSetNames.ToArray();
		}
		
		public override void Run()
		{
			currentTaskSetIndex ++;
			RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED, "ACXg[Jn");
			
			foreach (Uninstallation uninst in Uninstallations) {
				RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED_TASKSET, uninst.ToString());
				
				if (uninst.Installed) {
					try {
						uninst.OutputDataReceived += this.ReceivedOutputData;
						uninst.ErrorDataReceived += this.ReceivedErrorData;
						int exitCode = uninst.Uninstall();
						if (exitCode != 0) {
							RaiseTaskSetEvent(NaGetTaskSetEventType.WARNING, "ACXg[ɏIĂȂ\܂BvZX̏IR[h:"+exitCode);
						}
					} catch (Exception e) {
						RaiseTaskSetEvent(NaGetTaskSetEventType.ERROR, e.Message);
						done = true;
						return;
					}
				} else {
					RaiseTaskSetEvent(NaGetTaskSetEventType.WARNING, string.Format("{0}͊ɃACXg[Ă邩A\tg݂̑mFł܂ł", uninst));
				}
				
				RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED_TASKSET, uninst.ToString());
			}
			
			runLocalUpdate();
			
			done = true;
			
			RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED, "I", 100);
		}
		
		private void runLocalUpdate()
		{
			// CXg[gXg̍XV
			RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED_TASKSET, TaskSetNames[currentTaskSetIndex]);
			pkgListMan.DetectInstalledPkgs();
			pkgListMan.SaveInstalledPackageList();
			RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED_TASKSET, TaskSetNames[currentTaskSetIndex]);
			currentTaskSetIndex++;
		
			// VXeɃCXg[Ă郊Xg̍XV
			RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED_TASKSET, TaskSetNames[currentTaskSetIndex]);
			pkgListMan.DetectSystemInstalledPkgs();
			pkgListMan.SaveSystemInstalledPackageList();
			RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED_TASKSET, TaskSetNames[currentTaskSetIndex]);
			currentTaskSetIndex++;
		}
		
		public override bool Done {
			get { return done; }
		}
				
		public override int CurrentTaskSetIndex {
			get { return currentTaskSetIndex; }
		}
	}
}
