﻿using System;
using System.Drawing;
using System.Windows.Forms;
using NaGet.Packages;
using NaGet.Packages.Install;
using System.IO;
using System.Collections.Generic;

namespace AppliStation.Util
{
	/// <summary>
	/// ListViewのソートをカプセル化するためのクラス
	/// </summary>
	class ListViewItemSortComparer : System.Collections.IComparer
	{
		/// <summary>
		/// ソートの方向。昇順か?降順か?
		/// </summary>
		public SortOrder Order = SortOrder.Ascending;
		
		/// <summary>
		/// ソート対象のコラムインデックス
		/// </summary>
		public int Column = -1;
		
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="index">ソート対象のコラムインデックス</param>
		/// <param name="order">ソートの方向。昇順か?降順か?</param>
		public ListViewItemSortComparer(int index, SortOrder order)
		{
			this.Column = index;
			this.Order = order;
		}
		
		public int Compare(object x, object y)
		{
			ListViewItem itemx = (ListViewItem) x;
			ListViewItem itemy = (ListViewItem) y;
			
			int result = -1;
			result = string.Compare(itemx.SubItems[Column].Text,
			                        itemy.SubItems[Column].Text);
			
			switch (Order) {
				case SortOrder.Descending:
					result =  -result;
					break;
				case SortOrder.None:
					result = 0;
					break;
			}
			return result;
		}
	}
}
