// Dialog.cpp: _CAO֌W
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Dialog.h"
#include "resource.h"
#include "Common/StdOutStream.h"

#include "Windows/FileDir.h"
#include "Windows/FileIO.h"
#include "Common/UTFConvert.h"

#include <commctrl.h>

extern BOOL HandlerRoutine();

// ȈSHGetFileInfo(WWin9xnΉ)
static const FARPROC kSHGetFileInfo = ::GetProcAddress(::GetModuleHandle("SHELL32.DLL"), "SHGetFileInfoW");
DWORD MySHGetFileInfo(LPCWSTR pszPath, DWORD dwFileAttributes, SHFILEINFOW *psfi, UINT uFlags)
{
	if (g_IsNT)
	{
		DWORD (WINAPI* MySHGetFileInfoW)(LPCWSTR, DWORD, SHFILEINFOW*, UINT, UINT);
		(FARPROC&)MySHGetFileInfoW = kSHGetFileInfo;
		return MySHGetFileInfoW(pszPath, dwFileAttributes, psfi, sizeof(SHFILEINFOW), uFlags);
	}
	SHFILEINFOA shfi;
	DWORD dwRes = ::SHGetFileInfoA(::GetOemString(pszPath), dwFileAttributes, &shfi, sizeof(SHFILEINFOA), uFlags);
	psfi->hIcon = shfi.hIcon;
	psfi->iIcon = shfi.iIcon;
	psfi->dwAttributes = shfi.dwAttributes;
	if (uFlags & (SHGFI_DISPLAYNAME | SHGFI_ICONLOCATION))
		::MultiByteToWideChar(CP_OEMCP, 0, shfi.szDisplayName, -1, psfi->szDisplayName, MAX_PATH);
	else
		psfi->szDisplayName[0] = '\0';
	if (uFlags & SHGFI_TYPENAME)
		::MultiByteToWideChar(CP_OEMCP, 0, shfi.szTypeName, -1, psfi->szTypeName, 80);
	else
		psfi->szTypeName[0] = '\0';
	return dwRes;
}

// ݂̃vZXōŌɃANeBCuEBhE擾
BOOL CALLBACK GetProcessLastActivePopup(HWND hWnd, LPARAM lParam)
{
	DWORD dwProcessId;
	::GetWindowThreadProcessId(hWnd, &dwProcessId);
	if (::GetCurrentProcessId() == dwProcessId &&
		::GetWindow(hWnd, GW_OWNER) == NULL)
	{
		HWND* phWnd= (HWND*)lParam;
		*phWnd = ::GetLastActivePopup(hWnd);
		return FALSE;
	}
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// CDialog : _CAO{NX
//////////////////////////////////////////////////////////////////////

CDialog::CDialog()
{
	m_hWnd = NULL;
	m_hWndParent = NULL;
	m_nTemplateID = 0;
	m_bLoopExit = FALSE;
}

CDialog::~CDialog()
{

}

// Xgr[ɕݒiWWin9xnΉ)
void CDialog::ListView_SetItemTextW(HWND hwnd, int i, int iSubItem, LPCWSTR pszText)
{
	if (g_IsNT)
	{
		LVITEMW lvitem = { LVIF_TEXT, i, iSubItem, 0, 0, (LPWSTR)pszText };
		::SendMessageW(hwnd, LVM_SETITEMTEXTW, i, (LPARAM)&lvitem);
	}
	else
	{
		AString strOem = ::GetOemString(pszText);
		ListView_SetItemText(hwnd, i, iSubItem, strOem.GetBuffer(0));
	}
}

BOOL CDialog::DialogProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if (uMsg == WM_INITDIALOG)
	{
		((CDialog*)lParam)->m_hWnd = hDlg;
		::SetWindowLong(hDlg, GWL_USERDATA, lParam);
	}
	CDialog* pDlg = (CDialog*)::GetWindowLong(hDlg, GWL_USERDATA);
	return pDlg ? pDlg->DialogProc(uMsg, wParam, lParam) : 0;
}

BOOL CDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return 0;
}

// bZ[W[v
void CDialog::Loop()
{
	MSG msg;
	while (!m_bLoopExit && ::GetMessage(&msg, NULL, 0, 0))
	{
		if (msg.hwnd == NULL || !::IsDialogMessage(m_hWnd, &msg))
		{
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);

			if (msg.hwnd == m_hWndParent && msg.message == 0)
				::PostMessage(m_hWnd, WM_CLOSE, 0, 0);
		}
	}
	m_bLoopExit = FALSE;
}

// EBhEeEBhE̒SɈړ
void CDialog::MoveCenter()
{
	RECT rcOwner;
	RECT rcChild;
	RECT rcDesktop;

	::GetWindowRect(m_hWndParent ? m_hWndParent : ::GetDesktopWindow(), &rcOwner);
	::GetWindowRect(m_hWnd, &rcChild);
	::SystemParametersInfo(SPI_GETWORKAREA, 0, &rcDesktop, 0);
	int x = rcChild.left + (rcOwner.left + rcOwner.right - rcChild.left - rcChild.right) / 2;
	int y = rcChild.top + (rcOwner.top + rcOwner.bottom - rcChild.top - rcChild.bottom) / 2;
	if (x < rcDesktop.left) x = rcDesktop.left;
	if (y < rcDesktop.top) y = rcDesktop.top;
	if (x + rcChild.right - rcChild.left > rcDesktop.right) x = rcDesktop.right - (rcChild.right - rcChild.left);
	if (y + rcChild.bottom - rcChild.top > rcDesktop.bottom) y = rcDesktop.bottom - (rcChild.bottom - rcChild.top);
	::SetWindowPos(m_hWnd, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// [hX_CAOŃ[__CAO̓_CAO쐬B
BOOL CDialog::CreateModal()
{
	if (g_IsNT)
	{
		if (!::CreateDialogParamW(g_hInstance, MAKEINTRESOURCEW(m_nTemplateID), m_hWndParent, CDialog::DialogProc, (LPARAM)this))
			return FALSE;
	}
	else
	{
		if (!::CreateDialogParamA(g_hInstance, MAKEINTRESOURCEA(m_nTemplateID), m_hWndParent, CDialog::DialogProc, (LPARAM)this))
			return FALSE;
	}
	Loop();
	return TRUE;
}

// _CAÕRg[̕ݒiWWin9xnΉ)
BOOL CDialog::SetDlgItemTextW(int nID, LPCWSTR lpszString)
{
	if (g_IsNT)
		return ::SetDlgItemTextW(m_hWnd, nID, lpszString);
	return ::SetDlgItemTextA(m_hWnd, nID, GetOemString(lpszString));
}

// _CAÕRg[̕擾iWWin9xnΉ)
int CDialog::GetDlgItemTextW(int nID, UString& rString)
{
	rString.Empty();
	if (g_IsNT)
	{
		int nLen = ::GetWindowTextLengthW(::GetDlgItem(m_hWnd, nID));
		if (nLen)
		{
			++nLen;
			::GetDlgItemTextW(m_hWnd, nID, rString.GetBuffer(nLen), nLen);
			rString.ReleaseBuffer();
		}
	}
	else
	{
		AString string;
		int nLen = ::GetWindowTextLengthA(::GetDlgItem(m_hWnd, nID));
		if (nLen)
		{
			++nLen;
			::GetDlgItemTextA(m_hWnd, nID, string.GetBuffer(nLen), nLen);
			string.ReleaseBuffer();
		}
		rString = GetUnicodeString(string);
	}
	return rString.Length();
}

// _CAÕRg[ɓ悤pXZkɕϊ
BOOL CDialog::PathGetDlgItemPathW(int nID, UString& rString)
{
	HWND hItemWnd = ::GetDlgItem(m_hWnd, nID);
	HDC hDC = ::GetDC(hItemWnd);
	HGDIOBJ hFont = (HGDIOBJ)::SendMessage(hItemWnd, WM_GETFONT, 0, 0);
	HGDIOBJ hOldFont = ::SelectObject(hDC, hFont);
	RECT rc;
	int nRes;
	::GetClientRect(hItemWnd, &rc);
	if (g_IsNT)
	{
		nRes = ::DrawTextExW(hDC, rString.GetBuffer(rString.Length() + 4), rString.Length(), &rc, DT_PATH_ELLIPSIS | DT_MODIFYSTRING | DT_CALCRECT, NULL);
		rString.ReleaseBuffer();
	}
	else
	{
		AString string = GetOemString(rString);
		nRes = ::DrawTextExA(hDC, string.GetBuffer(string.Length() + 4), string.Length(), &rc, DT_PATH_ELLIPSIS | DT_MODIFYSTRING | DT_CALCRECT, NULL);
		string.ReleaseBuffer();
		rString = GetUnicodeString(string);
	}
	::SelectObject(hDC, hOldFont);
	::ReleaseDC(hItemWnd, hDC);
	return (nRes != 0);
}

// [__CAO쐬
int CDialog::DoModal()
{
	if (g_IsNT)
		return ::DialogBoxParamW(g_hInstance, MAKEINTRESOURCEW(m_nTemplateID), m_hWndParent, CDialog::DialogProc, (LPARAM)this);
	return ::DialogBoxParamA(g_hInstance, MAKEINTRESOURCEA(m_nTemplateID), m_hWndParent, CDialog::DialogProc, (LPARAM)this);
}

//////////////////////////////////////////////////////////////////////
// CProgressDialog : oߕ\_CAO
//////////////////////////////////////////////////////////////////////

static const UINT wm_arcextract = ::RegisterWindowMessageA(WM_ARCEXTRACT);
static HWND s_hOwnerWnd = NULL;
static HWND s_hOwnerWndEx = NULL;
static HWND s_hOwnerWndEx64 = NULL;
static LPARCHIVERPROC s_lpArcProc = NULL;
static LPARCHIVERPROC s_lpArcProc64 = NULL;
static DWORD s_dwStructSize = 0;

// bZ[WMEBhEݒ
BOOL CProgressDialog::SetOwnerWindow(HWND hWnd)
{
	if (s_hOwnerWnd || g_StdOut.m_hThread)
		return FALSE;
	s_hOwnerWnd = hWnd;
	return TRUE;
}

// SevenZipSetOwnerWindowExpݒۑ
BOOL CProgressDialog::SetOwnerWindowEx(HWND hWnd, LPARCHIVERPROC lpArcProc)
{
	if (s_hOwnerWndEx || g_StdOut.m_hThread || (hWnd ==NULL && lpArcProc == NULL))
		return FALSE;
	s_hOwnerWndEx = hWnd;
	s_lpArcProc = lpArcProc;
	return TRUE;
}

// SevenZipSetOwnerWindowEx64pݒۑ
BOOL CProgressDialog::SetOwnerWindowEx64(HWND hWnd, LPARCHIVERPROC lpArcProc, DWORD dwStructSize)
{
	if (s_hOwnerWndEx64 || g_StdOut.m_hThread || (hWnd ==NULL && lpArcProc == NULL))
		return FALSE;
	s_hOwnerWndEx64 = hWnd;
	s_lpArcProc64 = lpArcProc;
	s_dwStructSize = dwStructSize;
	return TRUE;
}

// I[i[EBhE
BOOL CProgressDialog::ClearOwnerWindow()
{
	if (s_hOwnerWnd == NULL || g_StdOut.m_hThread)
		return FALSE;
	s_hOwnerWnd = NULL;
	return TRUE;
}

// SevenZipSetOwnerWindowExpݒ
BOOL CProgressDialog::KillOwnerWindowEx(HWND hWnd)
{
	if ((hWnd && hWnd != s_hOwnerWndEx) || g_StdOut.m_hThread)
		return FALSE;
	s_hOwnerWndEx = NULL;
	s_lpArcProc = NULL;
	return TRUE;
}

// SevenZipSetOwnerWindowEx64pݒ
BOOL CProgressDialog::KillOwnerWindowEx64(HWND hWnd)
{
	if ((hWnd && hWnd != s_hOwnerWndEx64) || g_StdOut.m_hThread)
		return FALSE;
	s_hOwnerWndEx64 = NULL;
	s_lpArcProc64 = NULL;
	s_dwStructSize = 0;
	return TRUE;
}

CProgressDialog::CProgressDialog(HWND hParentWnd)
{
	m_hWndParent = hParentWnd;
	m_hDetailWnd = NULL;
	m_nTemplateID = IDD_PROGRESS;
	m_nTotalSize = 0;
	m_nSrcFileSize = 0;
	m_nStartOffset = 0;
	m_nCompletedSize = 0;
	m_bShow = FALSE;
	m_cMode = '\0';
	m_dwStartTime = 0;
	m_dwNowTime = 0;
	m_nArchiveType = 0;
	m_bSolid = false;
	::ZeroMemory(&m_eis64, sizeof(EXTRACTINGINFOEX64));
	m_eis64.dwStructSize = sizeof(EXTRACTINGINFOEX64);
}

BOOL CProgressDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_INITDIALOG:
		return OnInitDialog();
	case WM_CLOSE:
		if (lParam)
		{
			if (m_bShow)
				::EnableWindow(m_hWndParent, TRUE);
			::DestroyWindow(m_hWnd);
			m_bLoopExit = TRUE;
			break;
		}
		HandlerRoutine();
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDOK:
		case IDCANCEL:
			HandlerRoutine();
			break;
		case IDC_DETAIL:
			ShowDetail(::IsDlgButtonChecked(m_hWnd, IDC_DETAIL));
			break;
		default:
			return FALSE;
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

BOOL CProgressDialog::OnInitDialog()
{
	if (m_bShow)
	{
		char lpBuffer[64];
		m_detailItem.Add(IDS_COUNT_DOWN);
		m_detailItem.Add(IDS_PROCESS_FILE_SIZE);
		switch (m_cMode)
		{
		case 'a':
		case 'A':
			m_cMode = 'a';
			::LoadString(g_hInstance, IDS_PROGRESS_COMPRESS, lpBuffer, 64);
			m_detailItem.Add(IDS_FILE_TYPE);
			m_detailItem.Add(IDS_WRITE_TIME);
			m_detailItem.Add(IDS_ATTRIBUTE);
			break;
		case 'e':
		case 'E':
		case 'x':
		case 'X':
			m_cMode = 'x';
			::LoadString(g_hInstance, IDS_PROGRESS_EXTRACT, lpBuffer, 64);
			m_detailItem.Add(IDS_FILE_TYPE);
			m_detailItem.Add(IDS_WRITE_TIME);
			m_detailItem.Add(IDS_ATTRIBUTE);
			m_detailItem.Add(IDS_RATIO);
			m_detailItem.Add(IDS_METHOD);
			m_detailItem.Add(IDS_CRC);
			break;
		case 'd':
		case 'D':
			m_cMode = 'd';
			::LoadString(g_hInstance, IDS_PROGRESS_DELETE, lpBuffer, 64);
			break;
		case 'u':
		case 'U':
			m_cMode = 'a';
			::LoadString(g_hInstance, IDS_PROGRESS_UPDATE, lpBuffer, 64);
			m_detailItem.Add(IDS_FILE_TYPE);
			m_detailItem.Add(IDS_WRITE_TIME);
			m_detailItem.Add(IDS_ATTRIBUTE);
			break;
		default:
			::ResumeThread(g_StdOut.m_hThread);
			return FALSE;
		}
		::SetWindowText(m_hWnd, lpBuffer);
		::SendDlgItemMessage(m_hWnd, IDP_PROGRESS, PBM_SETRANGE32, 0, 1000);

		m_hDetailWnd = ::GetDlgItem(m_hWnd, IDL_DETAIL);
		LVCOLUMN lvcol = { LVCF_FMT | LVCF_WIDTH | LVCF_TEXT, LVCFMT_LEFT, 0, lpBuffer, 64 };
		::LoadString(g_hInstance, IDS_PROPERTY, lpBuffer, 64);
		ListView_InsertColumn(m_hDetailWnd, 0, &lvcol);
		::LoadString(g_hInstance, IDS_VALUE, lpBuffer, 64);
		ListView_InsertColumn(m_hDetailWnd, 1, &lvcol);

		LVITEM lvitem;
		lvitem.mask = TVIF_TEXT;
		lvitem.pszText = lpBuffer;
		lvitem.cchTextMax = 64;
		lvitem.iSubItem = 0;
		for (lvitem.iItem = 0; lvitem.iItem < m_detailItem.Size(); ++lvitem.iItem)
		{
			::LoadString(g_hInstance, m_detailItem[lvitem.iItem], lpBuffer, 64);
			ListView_InsertItem(m_hDetailWnd, &lvitem);
		}

		RECT rc;
		::GetWindowRect(m_hWnd, &rc);
		m_nWndHigh[1] = rc.bottom - rc.top;							// ڍו\̃EBhE̍
		::GetWindowRect(m_hDetailWnd, &rc);
		POINT pt = { rc.left, rc.top };
		::ScreenToClient(m_hWnd, &pt);
		m_nWndHigh[0]= pt.y + ::GetSystemMetrics(SM_CYCAPTION);		// ڍה\̃EBhE̍
		ShowDetail(FALSE);

		::GetClientRect(m_hDetailWnd, &rc);
		ListView_SetColumnWidth(m_hDetailWnd, 0, LVSCW_AUTOSIZE);
		ListView_SetColumnWidth(m_hDetailWnd, 1, rc.right - ListView_GetColumnWidth(m_hDetailWnd, 0));

		MoveCenter();
		::ShowWindow(m_hWnd, SW_SHOW);
		::EnableWindow(m_hWndParent, FALSE);
	}
	::ResumeThread(g_StdOut.m_hThread);
	return FALSE;
}

// A[JCu̕\ | mode 3 M
void CProgressDialog::SetArchiveFile(LPCWSTR lpFileName)
{
	m_nTotalSize = 0;
	m_nSrcFileSize = 0;
	m_nStartOffset = 0;
	m_nCompletedSize = 0;
	m_dwStartTime = ::GetTickCount();
	m_dwNowTime = 0;

	if (m_bShow)
	{
		UString strPath = lpFileName;
		PathGetDlgItemPathW(IDS_ARCHIVE_FILE, strPath);
		SetDlgItemTextW(IDS_ARCHIVE_FILE, strPath);
	}
	else
	{
		g_StdOut.WideCharToMultiByte(lpFileName, m_eis64.szSourceFileName, FNAME_MAX32);
		::lstrcpynA(m_eis64.exinfo.szSourceFileName, m_eis64.szSourceFileName, FNAME_MAX32);
		SendExtractingInfo(ARCEXTRACT_OPEN);
	}
}

// t@C̕\Aۑ | mode 0 M
void CProgressDialog::SetWorkFile(LPCWSTR lpSrcFileName, LPCWSTR lpDestFilePath, DWORD dwAttributes, bool bEncrypted, FILETIME ftLastWriteTime, UINT64 nSrcFileSize, UINT64 nCompFileSize, DWORD dwCRC, LPCWSTR lpMethod)
{
	m_strSrcFileName = lpSrcFileName;
	::NWindows::NFile::NDirectory::MyGetFullPathName(lpDestFilePath, m_strDestFilePath);
	m_nSrcFileSize = nSrcFileSize;
	m_eis64.dwAttributes = dwAttributes & (FILE_ATTRIBUTE_ARCHIVE | FILE_ATTRIBUTE_SYSTEM | FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_READONLY);
	if (bEncrypted)
		m_eis64.dwAttributes |= FA_ENCRYPTED;
	m_eis64.ftWriteTime = ftLastWriteTime;
	m_eis64.llCompressedSize = m_bSolid ? nCompFileSize : 0;
	m_eis64.dwCRC = dwCRC;
	m_eis64.wRatio = nSrcFileSize ? nCompFileSize * 1000 / nSrcFileSize : 0;
	m_strMethod = lpMethod;

	// ݒ
	if (m_bShow)
	{
		SetDetail();
		m_nStartOffset = m_nCompletedSize;
		UString strPath = m_strSrcFileName;
		PathGetDlgItemPathW(IDS_WORK_FILE, strPath);
		SetDlgItemTextW(IDS_WORK_FILE, strPath);
	}
	else
	{
		// @t@Cݒ
		g_StdOut.WideCharToMultiByte(m_strSrcFileName, m_eis64.szSourceFileName, FNAME_MAX32);
		g_StdOut.WideCharToMultiByte(m_strDestFilePath, m_eis64.szDestFileName, FNAME_MAX32);
		::lstrcpynA(m_eis64.exinfo.szSourceFileName, m_eis64.szSourceFileName, FNAME_MAX32);
		::lstrcpynA(m_eis64.exinfo.szDestFileName, m_eis64.szDestFileName, FNAME_MAX32);
		CStdOutStream::GetCompactMethod(m_strMethod, m_nArchiveType, m_eis64.szMode);
		SendExtractingInfo(ARCEXTRACT_BEGIN);
	}
}

// is̕\ | mode 1 M
void CProgressDialog::SetCompleted(UINT64 nSize)
{
	if (m_bShow)
	{
		m_nCompletedSize = nSize;
		char lpProcessSize[64];
		sprintf(lpProcessSize, "%I64u/%I64u", nSize, m_nTotalSize);
		UINT nRatio = m_nTotalSize ? (UINT)(nSize * 1000 / m_nTotalSize) : 0;
		::SendDlgItemMessage(m_hWnd, IDP_PROGRESS, PBM_SETPOS, nRatio, 0);
		::SetDlgItemText(m_hWnd, IDS_PROCESS_SIZE, lpProcessSize);
		if (m_bDetail)
		{
			if (nRatio)
			{
				DWORD dwElapse = ::GetTickCount() - m_dwStartTime;
				if (m_dwNowTime + 1000 < dwElapse)
				{
					m_dwNowTime = dwElapse;
					dwElapse = dwElapse / nRatio - dwElapse / 1000;
					sprintf(lpProcessSize, "%d:%.2d:%.2d", dwElapse / 3600, (dwElapse / 60) % 60, dwElapse % 60);
					ListView_SetItemText(m_hDetailWnd, 0, 1, lpProcessSize);
				}
			}
			sprintf(lpProcessSize, "%I64u/%I64u", nSize - m_nStartOffset, m_nSrcFileSize);
			ListView_SetItemText(m_hDetailWnd, 1, 1, lpProcessSize);
		}
	}
	else
	{
		if (m_eis64.exinfo.dwFileSize == -1)
			m_eis64.exinfo.dwWriteSize = m_nTotalSize ? (DWORD)(nSize * 1000 / m_nTotalSize) : 0;
		else
			m_eis64.exinfo.dwWriteSize = (DWORD)nSize;
		m_eis64.llWriteSize = nSize;
		if (!m_strSrcFileName.IsEmpty() || m_cMode == 'd')
			SendExtractingInfo(ARCEXTRACT_INPROCESS);
	}
}

// Ŝ̃TCY\
void CProgressDialog::SetTotal(UINT64 nSize)
{
	m_nTotalSize = nSize;
	if (m_bShow)
	{
		char lpProcessSize[64];
		sprintf(lpProcessSize, "0/%I64u", nSize);
		::SetDlgItemText(m_hWnd, IDS_PROCESS_SIZE, lpProcessSize);
		if (m_cMode == 'd')
			m_nSrcFileSize = nSize;
	}
	else
	{
		if (nSize < 0xFFFFFFFF)
			m_eis64.exinfo.dwFileSize = (DWORD)nSize;
		else
			m_eis64.exinfo.dwFileSize = -1;
		m_eis64.llFileSize = nSize;
	}
}

// I[i[EBhEɏn
void CProgressDialog::SendExtractingInfo(int nMode)
{
	if (m_bShow)
		return;

	BOOL bRes = FALSE;
	if (s_hOwnerWndEx64 || s_lpArcProc64)
	{
		if (s_dwStructSize == sizeof(EXTRACTINGINFOEX64))
		{
			if (s_lpArcProc64)
				bRes = !s_lpArcProc64(s_hOwnerWndEx64, wm_arcextract, nMode, nMode == 2 ? NULL : &m_eis64);
			else
				bRes = ::SendMessage(s_hOwnerWndEx64, wm_arcextract, nMode, nMode == 2 ? 0 : (LPARAM)&m_eis64);
		}
		else if (s_dwStructSize == sizeof(EXTRACTINGINFOEX32))
		{
			EXTRACTINGINFOEX32 eis;
			eis.dwStructSize = sizeof(EXTRACTINGINFOEX32);
			eis.exinfo = m_eis64.exinfo;
			eis.dwFileSize = eis.exinfo.dwFileSize;
			eis.dwCompressedSize = m_eis64.llCompressedSize < 0xFFFFFFFF ? (DWORD)m_eis64.llCompressedSize : -1;
			eis.dwWriteSize = eis.exinfo.dwWriteSize;
			eis.dwAttributes = m_eis64.dwAttributes;
			eis.dwCRC = m_eis64.dwCRC;
			eis.uOSType = m_eis64.uOSType;
			eis.wRatio = m_eis64.wRatio;
			eis.ftCreateTime = m_eis64.ftCreateTime;
			eis.ftAccessTime = m_eis64.ftAccessTime;
			eis.ftWriteTime = m_eis64.ftWriteTime;
			::lstrcpynA(eis.szMode, m_eis64.szMode, sizeof(eis.szMode));
			::lstrcpynA(eis.szSourceFileName, m_eis64.szSourceFileName, sizeof(eis.szSourceFileName));
			::lstrcpynA(eis.szDestFileName, m_eis64.szDestFileName, sizeof(eis.szDestFileName));

			if (s_lpArcProc64)
				bRes = !s_lpArcProc64(s_hOwnerWndEx64, wm_arcextract, nMode, nMode == 2 ? NULL : &eis);
			else
				bRes = ::SendMessage(s_hOwnerWndEx64, wm_arcextract, nMode, nMode == 2 ? 0 : (LPARAM)&eis);
		}
		else if (s_dwStructSize == sizeof(EXTRACTINGINFOEX))
		{
			FILETIME ftLocal;
			EXTRACTINGINFOEX eis;
			eis.exinfo = m_eis64.exinfo;
			eis.dwCompressedSize = m_eis64.llCompressedSize < 0xFFFFFFFF ? (DWORD)m_eis64.llCompressedSize : -1;
			eis.dwCRC = m_eis64.dwCRC;
			eis.uOSType = m_eis64.uOSType;
			eis.wRatio = m_eis64.wRatio;
			::FileTimeToLocalFileTime(&m_eis64.ftWriteTime, &ftLocal);
			::FileTimeToDosDateTime(&ftLocal, &eis.wDate, &eis.wTime);
			CStdOutStream::GetAttributesString(m_eis64.dwAttributes, m_cMode == 'x', eis.szAttribute);
			::lstrcpynA(eis.szMode, m_eis64.szMode, sizeof(eis.szMode));

			if (s_lpArcProc64)
				bRes = !s_lpArcProc64(s_hOwnerWndEx64, wm_arcextract, nMode, nMode == 2 ? NULL : &eis);
			else
				bRes = ::SendMessage(s_hOwnerWndEx64, wm_arcextract, nMode, nMode == 2 ? 0 : (LPARAM)&eis);
		}
	}
	else if (s_hOwnerWndEx || s_lpArcProc)
	{
		FILETIME ftLocal;
		EXTRACTINGINFOEX eis;
		eis.exinfo = m_eis64.exinfo;
		eis.dwCompressedSize = m_eis64.llCompressedSize < 0xFFFFFFFF ? (DWORD)m_eis64.llCompressedSize : -1;
		eis.dwCRC = m_eis64.dwCRC;
		eis.uOSType = m_eis64.uOSType;
		eis.wRatio = m_eis64.wRatio;
		::FileTimeToLocalFileTime(&m_eis64.ftWriteTime, &ftLocal);
		::FileTimeToDosDateTime(&ftLocal, &eis.wDate, &eis.wTime);
		CStdOutStream::GetAttributesString(m_eis64.dwAttributes, m_cMode == 'x', eis.szAttribute);
		::lstrcpynA(eis.szMode, m_eis64.szMode, sizeof(eis.szMode));
		
		if (s_lpArcProc)
			bRes = !s_lpArcProc(s_hOwnerWndEx, wm_arcextract, nMode, nMode == 2 ? NULL : &eis);
		else
			bRes = ::SendMessage(s_hOwnerWndEx, wm_arcextract, nMode, nMode == 2 ? 0 : (LPARAM)&eis);
	}
	else if (s_hOwnerWnd)
		bRes = ::SendMessage(s_hOwnerWnd, wm_arcextract, nMode, nMode == 2 ? 0 : (LPARAM)&m_eis64.exinfo);
	if (bRes)
		HandlerRoutine();
}

// ڍו\؂ւ
void CProgressDialog::ShowDetail(BOOL bShow)
{
	m_bDetail = bShow;
	SetDetail();
	RECT rc;
	::GetWindowRect(m_hWnd, &rc);
	::MoveWindow(m_hWnd, rc.left, rc.top, rc.right - rc.left, m_nWndHigh[bShow ? 1 : 0], TRUE);
}

// ڍאݒ
void CProgressDialog::SetDetail()
{
	if (!m_bDetail)
		return;
	char lpBuffer[64];
	switch (m_cMode)
	{
	case 'a':
		CStdOutStream::GetAttributesString(m_eis64.dwAttributes, false, lpBuffer);
		ListView_SetItemText(m_hDetailWnd, FindDetailIndex(IDS_ATTRIBUTE), 1, lpBuffer);
		break;
	case 'x':
		CStdOutStream::GetAttributesString(m_eis64.dwAttributes, true, lpBuffer);
		ListView_SetItemText(m_hDetailWnd, FindDetailIndex(IDS_ATTRIBUTE), 1, lpBuffer);
		sprintf(lpBuffer, "%d.%d%%", m_eis64.wRatio / 10, m_eis64.wRatio % 10);
		ListView_SetItemText(m_hDetailWnd, FindDetailIndex(IDS_RATIO), 1, lpBuffer);
		ListView_SetItemTextW(m_hDetailWnd, FindDetailIndex(IDS_METHOD), 1, m_strMethod);
		sprintf(lpBuffer, "%.8X", m_eis64.dwCRC);
		ListView_SetItemText(m_hDetailWnd, FindDetailIndex(IDS_CRC), 1, lpBuffer);
		break;
	default:
		return;
	}
	SHFILEINFOW shfi;
	MySHGetFileInfo(m_strSrcFileName, 0, &shfi, SHGFI_TYPENAME | SHGFI_USEFILEATTRIBUTES);
	ListView_SetItemTextW(m_hDetailWnd, FindDetailIndex(IDS_FILE_TYPE), 1, shfi.szTypeName);

	FILETIME ftLocal;
	SYSTEMTIME stWrite = { 0 };
	::FileTimeToLocalFileTime(&m_eis64.ftWriteTime, &ftLocal);
	::FileTimeToSystemTime(&ftLocal, &stWrite);
	::wsprintf(lpBuffer, "%.4hu/%.2hu/%.2hu %.2hu:%.2hu:%.2hu", stWrite.wYear, stWrite.wMonth, stWrite.wDay, stWrite.wHour, stWrite.wMinute, stWrite.wSecond);
	ListView_SetItemText(m_hDetailWnd, FindDetailIndex(IDS_WRITE_TIME), 1, lpBuffer);
}


//////////////////////////////////////////////////////////////////////
// CPasswordDialog : pX[h̓_CAO
//////////////////////////////////////////////////////////////////////

CPasswordDialog::CPasswordDialog(BOOL bMode)
{
	m_hWndParent = NULL;
	CProgressDialog* pProgDlg = g_StdOut.GetProgressDialog();
	if (pProgDlg == NULL)
		::EnumWindows(GetProcessLastActivePopup, (LPARAM)&m_hWndParent);
	else
		m_hWndParent = pProgDlg->GetBecomeParentWindow();
	m_nTemplateID = IDD_PASSWORD;
	m_bMode = bMode;
}

BOOL CPasswordDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LRESULT (WINAPI *MySendMessage)(HWND, UINT, WPARAM, LPARAM) = g_IsNT ? ::SendMessageW : ::SendMessageA;
	switch (uMsg)
	{
	case WM_INITDIALOG:
		{
			char lpBuffer[64];
			::LoadString(g_hInstance, m_bMode ? IDS_ENCRYPT : IDS_DECRYPT, lpBuffer, 64);
			::SetWindowText(m_hWnd, lpBuffer);
			m_hPassWnd = ::GetDlgItem(m_hWnd, IDE_PASSWORD);
			m_cMask = MySendMessage(m_hPassWnd, EM_GETPASSWORDCHAR, 0, 0);
			MoveCenter();
			break;
		}
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_MASK:
			MySendMessage(m_hPassWnd, EM_SETPASSWORDCHAR, ::SendMessage((HWND)lParam, BM_GETCHECK, 0, 0) == BST_CHECKED ? 0 : m_cMask, 0);
			::InvalidateRect(::GetDlgItem(m_hWnd, IDE_PASSWORD), NULL, TRUE);
			break;
		case IDOK:
			GetDlgItemTextW(IDE_PASSWORD, m_strPassword);
			::EndDialog(m_hWnd, IDOK);
			break;
		case IDCANCEL:
			::EndDialog(m_hWnd, IDCANCEL);
			break;
		default:
			return FALSE;
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// CConfirmationDialog : ㏑mF_CAO
//////////////////////////////////////////////////////////////////////

CConfirmationDialog::CConfirmationDialog()
{
	m_hWndParent = g_StdOut.GetProgressDialog()->GetBecomeParentWindow();
	m_nTemplateID = IDD_CONFIRMATION;
}

BOOL CConfirmationDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_INITDIALOG:
		{
			::SendMessage(::GetDlgItem(m_hWnd, IDS_REPLACE), STM_SETICON, (WPARAM)::LoadIcon(::GetModuleHandle("SHELL32.DLL"), MAKEINTRESOURCE(145)), 0);
			
			FILETIME ftLocal;
			SYSTEMTIME stWrite;
			TCHAR lpFormat[128];
			UString strFileInfo;
			SHFILEINFOW shFileInfoW;
			
			::FileTimeToLocalFileTime(&m_ftNewWrite, &ftLocal);
			::FileTimeToSystemTime(&ftLocal, &stWrite);
			::GetDlgItemText(m_hWnd, IDS_NEW_FILE_INFO, lpFormat, 128);
			UString strPath = m_strNewName;
			PathGetDlgItemPathW(IDS_NEW_FILE_INFO, strPath);
			swprintf(strFileInfo.GetBuffer(m_strNewName.Length() + 128), (LPCWSTR)GetUnicodeString(lpFormat), (LPCWSTR)strPath, stWrite.wYear, stWrite.wMonth, stWrite.wDay, stWrite.wHour, stWrite.wMinute, stWrite.wSecond, m_nNewSize);
			strFileInfo.ReleaseBuffer();
			MySHGetFileInfo(m_strNewName, FILE_ATTRIBUTE_NORMAL, &shFileInfoW, SHGFI_ICON | SHGFI_USEFILEATTRIBUTES | SHGFI_LARGEICON);
			::SendMessage(::GetDlgItem(m_hWnd, IDS_NEW_ICON), STM_SETICON, (WPARAM)shFileInfoW.hIcon, 0);
			SetDlgItemTextW(IDS_NEW_FILE_INFO, strFileInfo);
			
			::FileTimeToLocalFileTime(&m_ftOldWrite, &ftLocal);
			::FileTimeToSystemTime(&ftLocal, &stWrite);
			::GetDlgItemText(m_hWnd, IDS_OLD_FILE_INFO, lpFormat, 128);
			strPath = m_strOldName;
			PathGetDlgItemPathW(IDS_OLD_FILE_INFO, strPath);
			swprintf(strFileInfo.GetBuffer(m_strOldName.Length() + 128), (LPCWSTR)GetUnicodeString(lpFormat), (LPCWSTR)strPath, stWrite.wYear, stWrite.wMonth, stWrite.wDay, stWrite.wHour, stWrite.wMinute, stWrite.wSecond, m_nOldSize);
			strFileInfo.ReleaseBuffer();
			MySHGetFileInfo(m_strOldName, FILE_ATTRIBUTE_NORMAL, &shFileInfoW, SHGFI_ICON | SHGFI_USEFILEATTRIBUTES | SHGFI_LARGEICON);
			::SendMessage(::GetDlgItem(m_hWnd, IDS_OLD_ICON), STM_SETICON, (WPARAM)shFileInfoW.hIcon, 0);
			SetDlgItemTextW(IDS_OLD_FILE_INFO, strFileInfo);

			MoveCenter();
			return TRUE;
		}
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDB_YES:
		case IDB_NO:
		case IDB_YES_ALL:
		case IDB_NO_ALL:
		case IDB_AUTO_RENAME:
		case IDCANCEL:
			::EndDialog(m_hWnd, (int)LOWORD(wParam));
			break;
		default:
			return FALSE;
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

// t@C̐ݒ
void CConfirmationDialog::SetFileInfo(LPCWSTR lpNewName, UINT64 nNewSize, const FILETIME &ftNewWrite, LPCWSTR lpOldName, UINT64 nOldSize, const FILETIME &ftOldWrite)
{
	::NWindows::NFile::NDirectory::MyGetFullPathName(lpOldName, m_strOldName);
	m_strNewName = lpNewName;
	m_nNewSize = nNewSize;
	m_nOldSize = nOldSize;
	m_ftNewWrite = ftNewWrite;
	m_ftOldWrite = ftOldWrite;
}

//////////////////////////////////////////////////////////////////////
// CConfigDialog : ݒ_CAO
//////////////////////////////////////////////////////////////////////

CConfigDialog::CConfigDialog(HWND hParentWnd)
{
	m_hWndParent = hParentWnd;
	m_nTemplateID = IDD_CONFIG;
}

BOOL CConfigDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_INITDIALOG:
		{
			TCHAR lpVersion[64];
			::wsprintf(lpVersion, "7-zip32.dll version %d.%.2d.%.2d.%.2d", ::SevenZipGetVersion() / 100, ::SevenZipGetVersion() % 100, ::SevenZipGetSubVersion() / 100, ::SevenZipGetSubVersion() % 100);
			::SetDlgItemText(m_hWnd, IDS_VERSION, lpVersion);
			MoveCenter();
		}
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDOK:
		case IDCANCEL:
			::EndDialog(m_hWnd, LOWORD(wParam));
			break;
		default:
			return FALSE;
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// CSfxDialog : SFX쐬_CAO
//////////////////////////////////////////////////////////////////////

CSfxDialog::CSfxDialog(HWND hParentWnd)
{
	m_hWndParent = hParentWnd;
	m_nTemplateID = IDD_SFX;
}

BOOL CSfxDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_INITDIALOG:
		::EnableWindow(::GetDlgItem(m_hWnd, IDE_RUN_PROGRAM), FALSE);
		::EnableWindow(::GetDlgItem(m_hWnd, IDE_DIRECTORY), FALSE);
		::EnableWindow(::GetDlgItem(m_hWnd, IDE_EXECUTE_FILE), FALSE);
		::EnableWindow(::GetDlgItem(m_hWnd, IDE_EXECUTE_PARAMETERS), FALSE);
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_PROGRESS), FALSE);
		::CheckDlgButton(m_hWnd, IDC_PROGRESS, BST_CHECKED);
		MoveCenter();
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDOK:
			{
				UString strName = g_StdOut.GetTempSFXName();
				NWindows::NFile::NIO::COutFile file;
				UInt32 processedSize;
				file.Create(strName, true);

				HRSRC hResInfo = ::FindResource(g_hInstance, MAKEINTRESOURCE(IDR_7ZSDJC), "SFX");
				HGLOBAL hResData = ::LoadResource(g_hInstance, hResInfo);
				DWORD dwSize = ::SizeofResource(g_hInstance, hResInfo);
				LPVOID lpBuffer = ::LockResource(hResData);
				file.Write(lpBuffer, dwSize, processedSize);

				UString strText;
				AString utfString = ";!@Install@!UTF-8!\r\n";
				file.Write((const char*)utfString, utfString.Length(), processedSize);
				GetDlgItemTextW(IDE_TITLE, strText);
				if (!strText.IsEmpty())
				{
					ConvertUnicodeToUTF8(strText, utfString);
					utfString = "Title=\"" + utfString + "\"\r\n";
					file.Write((const char*)utfString, utfString.Length(), processedSize);
				}
				GetDlgItemTextW(IDE_BEGIN_PROMPT, strText);
				if (!strText.IsEmpty())
				{
					ConvertUnicodeToUTF8(strText, utfString);
					utfString = "BeginPrompt=\"" + utfString + "\"\r\n";
					file.Write((const char*)utfString, utfString.Length(), processedSize);
				}
				if (::IsDlgButtonChecked(m_hWnd, IDC_IS_INSTALLER))
				{
					utfString = "IsInstaller=\"yes\"\r\n";
					file.Write((const char*)utfString, utfString.Length(), processedSize);
					GetDlgItemTextW(IDE_RUN_PROGRAM, strText);
					if (!strText.IsEmpty())
					{
						ConvertUnicodeToUTF8(strText, utfString);
						utfString = "RunProgram=\"" + utfString + "\"\r\n";
						file.Write((const char*)utfString, utfString.Length(), processedSize);
					}
					GetDlgItemTextW(IDE_DIRECTORY, strText);
					if (!strText.IsEmpty())
					{
						ConvertUnicodeToUTF8(strText, utfString);
						utfString = "Directory=\"" + utfString + "\"\r\n";
						file.Write((const char*)utfString, utfString.Length(), processedSize);
					}
					GetDlgItemTextW(IDE_EXECUTE_FILE, strText);
					if (!strText.IsEmpty())
					{
						ConvertUnicodeToUTF8(strText, utfString);
						utfString = "ExecuteFile=\"" + utfString + "\"\r\n";
						file.Write((const char*)utfString, utfString.Length(), processedSize);
					}
					GetDlgItemTextW(IDE_EXECUTE_PARAMETERS, strText);
					if (!strText.IsEmpty())
					{
						ConvertUnicodeToUTF8(strText, utfString);
						utfString = "ExecuteParameters=\"" + utfString + "\"\r\n";
						file.Write((const char*)utfString, utfString.Length(), processedSize);
					}
					utfString = "Progress=\"";
					utfString += ::IsDlgButtonChecked(m_hWnd, IDC_PROGRESS) ? "yes" : "no";
					utfString += "\"\r\n";
					file.Write((const char*)utfString, utfString.Length(), processedSize);
				}
				utfString = ";!@InstallEnd@!";
				file.Write((const char*)utfString, utfString.Length(), processedSize);

				file.Close();
			}
			// ȉIDCANCELƓȂ̂break͖
		case IDCANCEL:
			::EndDialog(m_hWnd, LOWORD(wParam));
			break;
		case IDC_IS_INSTALLER:
			{
				BOOL bIsChecked = ::IsDlgButtonChecked(m_hWnd, IDC_IS_INSTALLER);
				::EnableWindow(::GetDlgItem(m_hWnd, IDE_RUN_PROGRAM),  bIsChecked);
				::EnableWindow(::GetDlgItem(m_hWnd, IDE_DIRECTORY), bIsChecked);
				::EnableWindow(::GetDlgItem(m_hWnd, IDE_EXECUTE_FILE), bIsChecked);
				::EnableWindow(::GetDlgItem(m_hWnd, IDE_EXECUTE_PARAMETERS), bIsChecked);
				::EnableWindow(::GetDlgItem(m_hWnd, IDC_PROGRESS), bIsChecked);
				break;
			}
		default:
			return FALSE;
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}