﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Xml.Serialization;
using System.Text.RegularExpressions;
using NaGet.Packages;

namespace NaGet.Packages.Install
{	
	public class InstalledPackage : Package
	{
		/// <summary>
		/// アンインストール情報
		/// </summary>
		public UninstallInformation UninstallInfo;
		
		public static InstalledPackage PackageConverter(Package basePkg) 
		{
			InstalledPackage pkg = new InstalledPackage();
			
			NaGet.Utils.FieldCopy(basePkg, ref pkg);
			pkg.UninstallInfo = UninstallInformation.NewInstance(basePkg);
			
			return pkg;
		}
		
		public static InstalledPackage PackageConverter(Package basePkg, UninstallInformation info)
		{
			InstalledPackage instPkg = new InstalledPackage();
			
			NaGet.Utils.FieldCopy(basePkg, ref instPkg);
			instPkg.UninstallInfo = info;
			
			Match match = Regex.Match(info.DisplayName, basePkg.UninstallerKey);
			if (! match.Success) {
				throw new ArgumentException(string.Format("{0}({1}) does not matched for {2}.", basePkg.Name, basePkg.Version, info.DisplayName));
			} else if (match.Groups[1].Success) { // DisplayNameの方のバージョン表記を優先
				instPkg.Version = match.Groups[1].Value;
			} else if (! string.IsNullOrEmpty(info.DisplayVersion) ) {
				instPkg.Version = info.DisplayVersion;
			} else {
				instPkg.Version = string.Empty;
			}
			
			return instPkg;
		}
	}
}
