﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;

namespace AppliStation
{
	class Program
	{
		Form splashScreen;
		
		PackageListViewForm form;
		
		/// <summary>
		/// アプリケーションのオプション
		/// </summary>
		Dictionary<string, object> appArgs;
		
		string[] restAppArgs;
		
		public Program()
		{
			appArgs = new Dictionary<string, object>();
			appArgs["noupdate"] = false;
			appArgs["cmd"] = string.Empty;
			appArgs["pkgsref"] = string.Empty;
			appArgs["instsref"] = string.Empty;
			
			form = new PackageListViewForm();
		}
		
		void RunNormal()
		{
			form.Load += delegate(object sender, EventArgs e) {
				hideSplashScreen();
				form.updateActionInvoke(((bool)appArgs["noupdate"]) != true);
				
				form.UpdatePackageList();
			};
			Application.Run(form);
		}
		
		void RunInstall()
		{
			try {
				NaGet.Packages.Install.Installation[] insts = NaGet.Utils.GetDeserializedObject<NaGet.Packages.Install.Installation[]>((string) appArgs["instsref"]);
				
				hideSplashScreen();
				form.installActionInvoke(insts);
			} catch (UnauthorizedAccessException e) {
				MessageBox.Show(string.Format("管理者権限に昇格していないか、実行権限に問題があります。\n(詳細:{0})", e.Message),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			} catch (FileNotFoundException e) {
				MessageBox.Show(string.Format("ソフト指定ファイル{0}が見つかりません", e.FileName),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		
		void RunUninstall()
		{
			try {
				NaGet.Packages.Install.InstalledPackage[] pkgs = NaGet.Utils.GetDeserializedObject<NaGet.Packages.Install.InstalledPackage[]>((string) appArgs["pkgsref"]);
				
				hideSplashScreen();
				form.uninstallActionInvoke(pkgs);
			} catch (UnauthorizedAccessException e) {
				MessageBox.Show(string.Format("管理者権限に昇格していないか、実行権限に問題があります。\n(詳細:{0})", e.Message),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			} catch (FileNotFoundException e) {
				MessageBox.Show(string.Format("ソフト指定ファイル{0}が見つかりません", e.FileName),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		
		private void hideSplashScreen()
		{
			if (splashScreen != null && splashScreen.Visible) {
				splashScreen.Hide();
				splashScreen.Dispose();
			}
		}
		
		public void Run(string[] args)
		{
			try {
				parseArgs(args);
			} catch (ApplicationException e) {
				MessageBox.Show(e.Message, "AppliStation 起動引数エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
			
			switch ((string) appArgs["cmd"]) {
				case "install":
					RunInstall();
					break;
				case "uninstall":
					RunUninstall();
					break;
				default:
					RunNormal();
					break;
			}
		}
		
		private void parseArgs(string[] args)
		{
			NaGet.ArgParser parser = new NaGet.ArgParser(appArgs);
			restAppArgs = parser.Parse(args);
		}
		
		[STAThread]
		public static void Main(string[] args)
		{
			Form splashScreen = null;
			
			try {
				if (args.Length <= 0) { // HACK 引数パースの時間さえ待てないので引数の有無で表示を判断
					splashScreen = new Form();
					splashScreen.FormBorderStyle = FormBorderStyle.None;
					splashScreen.BackgroundImage = System.Drawing.Bitmap.FromFile(Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), "SplashScreen.png"));
					splashScreen.Size = splashScreen.BackgroundImage.Size;
					splashScreen.ShowIcon = false;
					splashScreen.ShowInTaskbar = false;
					splashScreen.StartPosition = FormStartPosition.CenterScreen;
					splashScreen.Show();
				}
				
				ToolStripManager.VisualStylesEnabled = false; // ToolStripがLunaで青くならないように
				Application.EnableVisualStyles(); // LunaやVistaのデザインを有効に
				
				Application.ThreadException += AppliStation.Util.ExceptionDialogForm.Application_ThrowException;
				System.Threading.Thread.GetDomain().UnhandledException += AppliStation.Util.ExceptionDialogForm.Application_ThrowException;
				
				Program prog = new Program();
				prog.splashScreen = splashScreen;
				prog.Run(args);
			} catch (Exception e) {
				AppliStation.Util.ExceptionDialogForm.Application_ThrowException(null, new System.Threading.ThreadExceptionEventArgs(e));
			} finally {
				if (splashScreen != null) {
					splashScreen.Dispose();
				}
			}
		}
	}
}
