using System;
using System.Drawing;
using System.Windows.Forms;
using NaGet.Packages;
using NaGet.Packages.Install;
using System.IO;
using System.Collections.Generic;

namespace AppliStation.Util
{
	/// <summary>
	/// ListView̃\[gJvZ邽߂̃NX
	/// </summary>
	class ListViewItemSortComparer : System.Collections.IComparer
	{
		/// <summary>
		/// \[g̕B?~?
		/// </summary>
		public SortOrder Order = SortOrder.Ascending;
		
		/// <summary>
		/// \[gΏۂ̃RCfbNX
		/// </summary>
		public int Column = -1;
		
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="index">\[gΏۂ̃RCfbNX</param>
		/// <param name="order">\[g̕B?~?</param>
		public ListViewItemSortComparer(int index, SortOrder order)
		{
			this.Column = index;
			this.Order = order;
		}
		
		public int Compare(object x, object y)
		{
			ListViewItem itemx = (ListViewItem) x;
			ListViewItem itemy = (ListViewItem) y;
			
			int result = -1;
			result = string.Compare(itemx.SubItems[Column].Text,
			                        itemy.SubItems[Column].Text);
			
			switch (Order) {
				case SortOrder.Descending:
					result =  -result;
					break;
				case SortOrder.None:
					result = 0;
					break;
			}
			return result;
		}
	}
}
