using System;

namespace NaGet.SubCommands
{
	public class NaGetTaskSetEventArgs : NaGetEventArgs
	{
		public NaGetTaskSetEventType Type;
		
		public NaGetTaskSetEventArgs(NaGetTaskSetEventType type, string message, float processPercent)
		{
			this.Type = type;
			this.TaskMessage = message;
			this.TaskProgressPercent = processPercent;
		}
	}
	
	/// <summary>
	/// ^XN̎
	/// </summary>
	public enum NaGetTaskSetEventType
	{
		/// <summary>
		/// Jn
		/// </summary>
		STARTED,
		/// <summary>
		/// (ׂĂ)
		/// </summary>
		COMPLETED,
		/// <summary>
		/// ƂLZꂽ
		/// </summary>
		CANCELED,
		/// <summary>
		/// G[𔭐(f)
		/// </summary>
		ERROR,
		/// <summary>
		/// G[p
		/// </summary>
		WARNING,
		/// <summary>
		/// ̂ق̏
		/// </summary>
		INFO,
		/// <summary>
		/// ƂJn
		/// </summary>
		STARTED_TASKSET,
		/// <summary>
		/// ƂI
		/// </summary>
		COMPLETED_TASKSET
	}
	
	/// <summary>
	/// NaGet^XÑpbN
	/// </summary>
	public abstract class NaGetTaskSet : NaGetTask
	{
		/// <summary>
		/// ^XÑCxgnh
		/// </summary>
		public event EventHandler<NaGetTaskSetEventArgs> TaskSetRaised;
		
		/// <summary>
		/// ŕ\ƈꗗXg
		/// </summary>
		public string[] TaskSetNames;
		
		/// <summary>
		/// ݎs̍Ɣԍ
		/// </summary>
		public abstract int CurrentTaskSetIndex {
			get;
		}
		
		protected virtual void RaiseTaskSetEvent(NaGetTaskSetEventType type, string message)
		{
			float percent = (CurrentTaskSetIndex >= 0)? CurrentTaskSetIndex * 100 / TaskSetNames.Length : -1;
			RaiseTaskSetEvent(type, message, percent);
		}
		
		protected virtual void RaiseTaskSetEvent(NaGetTaskSetEventType type, string message, float percent)
		{
			RaiseTaskSetEvent(new NaGetTaskSetEventArgs(type, message, percent));
		}
		
		protected virtual void RaiseTaskSetEvent(NaGetTaskSetEventArgs e)
		{
			if (TaskSetRaised != null) {
				TaskSetRaised(this, e);
			}
		}
		
		protected virtual void ReceivedErrorData(object sender, NaGet.Utils.AnyDataEventArgs<string> e)
		{
			if (! string.IsNullOrEmpty(e.Data)) {
				RaiseTaskSetEvent(NaGetTaskSetEventType.WARNING, e.Data);
			}
		}
		
		protected virtual void ReceivedOutputData(object sender, NaGet.Utils.AnyDataEventArgs<string> e)
		{
			if (! string.IsNullOrEmpty(e.Data)) {
				RaiseTaskSetEvent(NaGetTaskSetEventType.INFO, e.Data);
			}
		}
		
		public override bool Running {
			get { return CurrentTaskSetIndex >= 0 && !Done; }
		}
	}
}
