using System;
using NaGet.Packages.Install;
using NaGet.Packages;
using NaGet.Net;

namespace NaGet.SubCommands
{
	public class NaGetInstall : NaGetTaskSet
	{
		private bool done = false;
		
		private int currentTaskSetIndex = -1;
		
		private PackageListsManager pkgListMan;
		
		public Downloader Downloader; // TODO QƂăZbg悤
		
		private bool packageInstallerDownloaded = false;
		
		public override bool Cancelable {
			get { return ! done; }
		}
		
		/// <summary>
		/// CXg[pbP[W
		/// </summary>
		public Installation[] Installations;
		
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="pkgs">CXg[pbP[W</param>
		public NaGetInstall(PackageListsManager pkgListMan, Package[] pkgs)
			: this(pkgListMan, Installation.ConvertInstallations(pkgs))
		{
		}
		
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="installations">CXg[̔z</param>
		public NaGetInstall(PackageListsManager pkgMan, Installation[] installations)
		{
			pkgListMan = pkgMan;
			
			Installations = installations;
			initializeMainTaskSetNames();
		}
		
		private void initializeMainTaskSetNames()
		{
			System.Collections.Generic.List<string> taskSetNames = new System.Collections.Generic.List<string>();
			
			for (int i =0; i < Installations.Length; i++) {
				taskSetNames.Add(string.Format("擾: {0}", Installations[i].ToString()));
			}
			taskSetNames.Add("CXg[̌");
			for (int i =0; i < Installations.Length; i++) {
				taskSetNames.Add(string.Format("CXg[: {0}", Installations[i].ToString()));
			}
			taskSetNames.Add(string.Format("XgXV: {0}", NaGet.Env.ArchiveInstalledPackageListFile));
			taskSetNames.Add(string.Format("XgXV: {0}", NaGet.Env.SystemInstalledPackageListFile));
			
			TaskSetNames = taskSetNames.ToArray();
		}
		
		public override void Run()
		{
			currentTaskSetIndex ++;
			RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED, "CXg[Jn");
			
			foreach (Installation inst in Installations) {
				if (! inst.IsInstallablePackage()) {
					string msg = string.Format("{0}̓CXg[邱Ƃł܂", inst.ToString());
					
					RaiseTaskSetEvent(NaGetTaskSetEventType.ERROR, msg);
					done = true;
					return;
				}
				
				RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED_TASKSET, inst.ToString());
				
				if (! inst.Downloaded) {
					try {
						inst.Download(Downloader);
					} catch (NaGetTaskCanceledException) {
						RaiseTaskSetEvent(NaGetTaskSetEventType.CANCELED, "CXg[̃_E[hLZ܂");
						done = true;
						return;
					} catch (System.Net.WebException e) {
						RaiseTaskSetEvent(NaGetTaskSetEventType.WARNING, e.Message);
						if (System.Net.NetworkInformation.NetworkInterface.GetIsNetworkAvailable()) {
							RaiseTaskSetEvent(NaGetTaskSetEventType.ERROR, "lbg[NɐڑĂ܂B");
						} else {
							RaiseTaskSetEvent(NaGetTaskSetEventType.ERROR, "lbg[Nɐڑł܂łBlbg[NؒfĂ邩At@CAEH[ɂĎՒfꂽ\܂B");
						}
						done = true;
						return;
					} catch (Exception e) {
						RaiseTaskSetEvent(NaGetTaskSetEventType.ERROR, e.Message);
						done = true;
						return;
					}
				}
				currentTaskSetIndex ++;
				
				if (inst.Downloaded) { // I
					RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED_TASKSET, inst.ToString());
				} else { // CXg[ɏI=s=G[
					RaiseTaskSetEvent(NaGetTaskSetEventType.ERROR, string.Format("{0}̃CXg[𐳏Ƀ_E[hł܂ł", inst.ToString()));
				}
			}
			
			packageInstallerDownloaded = true;
			
			{
				bool invalid = false;
				int i = 0;
				foreach (Installation inst in Installations) {
					float percent = (CurrentTaskSetIndex+((float)i / Installations.Length))*100f/TaskSetNames.Length;
					
					if (inst.GetRegisteredHashCount() > 0) {
						RaiseTaskSetEvent(NaGetTaskSetEventType.INFO, ": "+inst.ToString(), percent);
						
						if (inst.IsInstallablePackage() && inst.VerifyHashValues() == false) {
							invalid = true;
							RaiseTaskSetEvent(NaGetTaskSetEventType.WARNING, ": "+inst.ToString() + " 񐮍", percent);
						} else {
							RaiseTaskSetEvent(NaGetTaskSetEventType.INFO, ": "+inst.ToString() + " OK", percent);
						}
					}
					i++;
				}
				
				// TODO nbVĂƂ̑΍
//				if (invalid && (! AllGet.Util.Confirm("Some packages do not match hash value. Are you really sure to install them [yN]?", false) )) {
//					Console.WriteLine("Abort.");
//					Environment.Exit(0);
//				}
				currentTaskSetIndex ++;
			}
			
			foreach (Installation inst in Installations) {
				RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED_TASKSET, inst.ToString());
				
				try {
					inst.ErrorDataReceived += this.ReceivedErrorData;
					inst.OutputDataReceived += this.ReceivedOutputData;
					int exitCode = inst.Install();
					if (exitCode != 0) {
						RaiseTaskSetEvent(NaGetTaskSetEventType.WARNING, "CXg[ɏIĂȂ\܂BCXg[̏IR[h:"+exitCode);
					}
					
					pkgListMan.WriteInstallationLog(inst);
				} catch (Exception e) {
					RaiseTaskSetEvent(NaGetTaskSetEventType.ERROR, e.Message);
					done = true;
					return;
				}
				currentTaskSetIndex ++;
				
				RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED_TASKSET, inst.ToString());
				
				if (cancelCalled) {
					RaiseTaskSetEvent(NaGetTaskSetEventType.CANCELED, "pbP[W̃CXg[LZ܂");
					done = true;
					return;
				}
			}
			pkgListMan.SaveSystemInstalledLogList(); // ÕR~bg
			
			runLocalUpdate();
			
			done = true;
			
			RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED, "I", 100);
		}
		
		private void runLocalUpdate()
		{
			// CXg[gXg̍XV
			RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED_TASKSET, TaskSetNames[currentTaskSetIndex]);
			pkgListMan.DetectInstalledPkgs();
			pkgListMan.SaveInstalledPackageList();
			currentTaskSetIndex++;
			RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED_TASKSET, TaskSetNames[currentTaskSetIndex-1]);
		
			// VXeɃCXg[Ă郊Xg̍XV
			RaiseTaskSetEvent(NaGetTaskSetEventType.STARTED_TASKSET, TaskSetNames[currentTaskSetIndex]);
			pkgListMan.DetectSystemInstalledPkgs();
			pkgListMan.SaveSystemInstalledPackageList();
			currentTaskSetIndex++;
			RaiseTaskSetEvent(NaGetTaskSetEventType.COMPLETED_TASKSET, TaskSetNames[currentTaskSetIndex-1]);
		}
		
		public override bool Done {
			get { return done; }
		}
		
		public override int CurrentTaskSetIndex {
			get { return currentTaskSetIndex; }
		}
		
		private bool cancelCalled = false;
		
		public override bool Cancel()
		{
			cancelCalled = true;
			if (! packageInstallerDownloaded) {
				return Downloader.Cancel();
			} else return true;
		}
	}
}
