using System;
using System.IO;
using System.Drawing;
using NaGet.Packages;
using NaGet.Packages.Install;

namespace AppliStation.Util
{
	public sealed class PackageUtils
	{
		
		public static Icon GetIconForPackage(InstalledPackage pkg)
		{
			string iconPath = pkg.UninstallInfo.IconPath;
			if (! string.IsNullOrEmpty(iconPath)) {
				if (iconPath.EndsWith(",0") || iconPath.EndsWith(",-0")) {
					iconPath = iconPath.Substring(0, iconPath.LastIndexOf(','));
				}
				if (File.Exists(iconPath)) {
					return Icon.ExtractAssociatedIcon(iconPath);
				}
			} else if (pkg.Type == InstallerType.ARCHIVE) {
				string progGrp = Path.Combine(NaGet.Env.ArchiveProgramGroup, pkg.Name);
				if (Directory.Exists(progGrp)) {
					string[] lnkFiles = Directory.GetFiles(progGrp, "*.lnk");
					
					if (lnkFiles.Length >= 1) {
						using (NaGet.InteropServices.ShellLink link = new NaGet.InteropServices.ShellLink(lnkFiles[0])) {
							if (File.Exists(link.GetPath(0))) {
								return Icon.ExtractAssociatedIcon(link.GetPath(0));
							}
						}
					}
				}
			}
			return null;
		}
		
	}
}
