package DBD::SalesForce;

# ----------------------------------------------------------------------
# $Id: SalesForce.pm,v 1.1 2004/02/04 17:27:45 dlc Exp $
# ----------------------------------------------------------------------

use strict;
use vars qw($VERSION $REVISION);
use vars qw($err $errstr $state $drh);

use DBI;
use DBD::SalesForce::dr;
use DBD::SalesForce::db;
use DBD::SalesForce::st;

$REVISION = '$Id: DatePlus.pm,v 1.1 2005/06/28 13:36:31 takayama Exp $';
$VERSION = $REVISION =~ /v ([\S]+) /;

# ----------------------------------------------------------------------
# Standard DBI globals: $DBI::err, $DBI::errstr, etc
# ----------------------------------------------------------------------
$err     = 0;
$errstr  = "";
$state   = "";
$drh     = undef;

# ----------------------------------------------------------------------
# Creates a new driver handle, which will be a singleton.
# ----------------------------------------------------------------------
sub driver {
    unless ($drh) {
        my ($class, $attr) = @_;
        my %stuff = (
            'Name'              => 'SalesForce',
            'Version'           => $VERSION,
            'DriverRevision'    => $REVISION,
            'Err'               => \$err,
            'Errstr'            => \$errstr,
            'State'             => \$state,
            'Attribution'       => 'DBD::SalesForce - jun shimizu <shimizu@shanon.co.jp>',
            'AutoCommit'        => 1, # to avoid errors
        );

        $class = join "::", $class, "dr";

        $drh = DBI::_new_drh($class, \%stuff);
    }

    return $drh;
}

sub DESTROY { 1 }

1;

__END__

=head1 NAME

DBD::SalesForce - Treat SalesForce as a datasource for DBI

=head1 SYNOPSIS

  use DBI;

  my $dbh = DBI->connect("dbi:SalesForce:", $id, $pass);
  my $sth = $dbh->prepare(qq[
      SELECT id, firstname, lastname FROM contact
  ]);

  while (my $r = $sth->fetchrow_hashref) {
      ...

=head1 DESCRIPTION

C<DBD::SalesForce> allows you to use SalesForce as a datasource; SalesForce can be
queried using SQL I<SELECT> statements, and iterated over using
standard DBI
conventions.

WARNING:  This is still alpha-quality software.  It works for me, but
that doesn't really mean anything.
