unit uSetUtils;

(*
 j 
Wƕ̑ݕϊ
http://www.asahi-net.or.jp/~HA3T-NKMR/tips024.htm

modified by moriq:

StrToSet:
ÕbZ[WύX܂B
- 'W@ϊG['
+ 'StrToSet convert error'
IWi͌Ă܂B
  '񁨏W@ϊG['
悤łB

SetToStr:
ЂƂvfȂƂ Result = '[]' ł͂Ȃ
Result = ']' ɂȂĂ܂oOCB
*)

interface

uses TypInfo;

// Wϊ
function SetToStr(SetType: PTypeInfo; const SetValue): string;
// 񁨏Wϊ
procedure StrToSet(SetType: PTypeInfo; str: string; var SetVar);


implementation

uses Windows, SysUtils;

function SetToStr(SetType: PTypeInfo; const SetValue): string;
var
  pd: PTypeData;
  CompType: PTypeInfo;
  i: Integer;
  pi: PInteger;
begin
  pd := GetTypeData(SetType);
  Assert(pd <> Nil);
  CompType := pd.CompType^;
  Assert(CompType <> Nil);
  pd := GetTypeData(CompType);
  Assert(pd <> Nil);

  pi := @SetValue;

  Result := '';

  for i := pd.MinValue to pd.MaxValue do
    if (pi^ and (1 shl i)) <> 0 then
      if Result = '' then Result := GetEnumName(CompType, i)
                     else Result := Result + ', ' +
                                    GetEnumName(CompType, i);
  Result := '[' + Result + ']';
end;

procedure StrToSet(SetType: PTypeInfo; str: string; var SetVar);
var
  pd: PTypeData;
  CompType: PTypeInfo;
  i: Integer;
  pdw: PDWORD;
  pw: PWORD;
  pb: PByte;
  p: PChar;
  EnumName: string;
  ENumValue: Integer;
begin
  pd := GetTypeData(SetType);
  Assert(pd <> Nil);
  CompType := pd.CompType^;
  Assert(CompType <> Nil);
  pd := GetTypeData(CompType);
  Assert(pd <> Nil);

  pdw := @SetVar;
  pw  := @SetVar;
  pb  := @SetVar;

  case pd.OrdType of
  otSByte, otUByte: pb^ := 0;
  otSWord, otUWord: pw^ := 0;
  otSLong, otULong: pdw^ := 0;
  end;


  p := PChar(Str);

  // '['  ' ' XLbv
  while p^ in ['[',' '] do Inc(p);

  // ','  ' ' #0 ']' ܂łvfƂĎo
  i := 0;
  while not (p[i] in [',', ' ', #0,']']) do Inc(i);
  SetString(EnumName, p, i);
  // ̌̐擪܂Ń|C^i߂
  while p[i] in [',', ' ',']'] do Inc(i);
  Inc(p, i);


  while EnumName <> '' do
  begin
    EnumValue := GetEnumValue(CompType, EnumName);
    if EnumValue < 0 then
      raise Exception.Create('StrToSet convert error');
    case pd.OrdType of
    otSByte, otUByte: pb^ := pb^ or (1 shl EnumValue);
    otSWord, otUWord: pw^ := pw^ or (1 shl EnumValue);
    otSLong, otULong: pdw^ := pdw^ or (1 shl EnumValue);
    end;
    // ','  ' ' #0 ']' ܂łvfƂĎo
    i := 0;
    while not (p[i] in [',', ' ', #0,']']) do Inc(i);
    SetString(EnumName, p, i);
    // ̌̐擪܂Ń|C^i߂
    while p[i] in [',', ' ',']'] do Inc(i);
    Inc(p, i);
  end;
end;

end.
