unit uTreeView;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies, uConv;

var
  cTreeView: Tvalue;

function ap_cTreeView: Tvalue;
function ap_iTreeView(real: TTreeView; owner: Tvalue): Tvalue;
procedure Init_TreeView;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uIO,
  uSizeConstraints, uCanvas, uFont, uTreeNode,
  uPersistent, uComponent, uControl;

function ap_cTreeView: Tvalue;
begin
  result := cTreeView;
end;

procedure TreeView_setup(obj: Tvalue; real: TTreeView);
begin
{$IFDEF VCL}
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
{$ENDIF}
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@items', ap_iTreeNodes(real.Items, obj));
//    AssignPropMethod(real, [Handle]);
end;

function TreeView_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function TreeView_alloc(This: Tvalue; real: TTreeView): Tvalue;
begin
  result := ChildAlloc(This, real);
  TreeView_setup(result, real);
end;

function ap_iTreeView(real: TTreeView; owner: Tvalue): Tvalue;
begin
  result := TreeView_alloc(cTreeView, real);
  ap_owner(result, owner);
end;

function ap_iTreeView_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iTreeView(TTreeView(AControl), owner);
end;

function TreeView_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
begin
  real := TTreeView.Create(nil);
  result := CompoAlloc(This, real);
  TreeView_setup(result, real);
end;

function TreeView_load(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.LoadFromFile(dl_String(v));
    except
      on E: EFOpenError do
        ap_raise(ap_eIOError, E.message);
    end;
  T_DATA:
    begin
      ap_data_get_object(v, TStream, stream);
      real.LoadFromStream(stream);
    end;
  end;
  rb_iv_set(This, '@items', ap_iTreeNodes(real.Items, This));
  result := This;
end;

function TreeView_save(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    real.SaveToFile(dl_String(v));
  T_DATA:
  begin
    ap_data_get_object(v, TStream, stream);
    real.SaveToStream(stream);
  end;
  end;
  result := v;
end;

function TreeView_get_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  node: TTreeNode;
begin
  real := ap_data_get_struct(This);
  node := real.Selected;
//  if node = nil then
//    result := Qnil
//  else
    result := ap_TreeNode(node);
//  ;
end;

function TreeView_set_selected(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  node: TTreeNode;
begin
  real := ap_data_get_struct(This);
  node := dl_TreeNode(v);
  real.Selected := node;
  result := v;
end;

function TreeView_get_node_at(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  node: TTreeNode;
begin
  real := ap_data_get_struct(This);
  node := real.GetNodeAt(FIX2INT(x), FIX2INT(y));
//  if node = nil then
//    result := Qnil
//  else
    result := ap_TreeNode(node);
end;

function TreeView_full_expand(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
begin
  real := ap_data_get_struct(This);
  real.FullExpand;
  result := This;
end;

function TreeView_full_collapse(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
begin
  real := ap_data_get_struct(This);
  real.FullCollapse;
  result := This;
end;

{$IFDEF VCL}
function TreeView_get_hit_test_info_at(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  ht: THitTests;
begin
  real := ap_data_get_struct(This);
  ht := real.GetHitTestInfoAt(FIX2INT(x), FIX2INT(y));
  result := ap_Set(ht);
end;
{$ENDIF}

(**** str_my_class made by ap_src_maker ****)
type
TPhi_TreeView = class(TTreeView)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function TreeView_alpha_sort(This, ARecurse : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_ARecurse : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_ARecurse := dl_Boolean(ARecurse);
  result := ap_Bool(real.AlphaSort( dlv_ARecurse ));
end;

function TreeView_is_editing(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.IsEditing);
end;

function TreeView_load_from_file(This, FileName : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_FileName : string;
begin
  real := ap_data_get_struct(This);
  dlv_FileName := dl_String(FileName);
  real.LoadFromFile( dlv_FileName );
  result := This;
end;

function TreeView_load_from_stream(This, Stream : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_Stream : TStream;
begin
  real := ap_data_get_struct(This);
  dlv_Stream := ap_data_get_struct(Stream);
  real.LoadFromStream( dlv_Stream );
  result := This;
end;

function TreeView_save_to_file(This, FileName : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_FileName : string;
begin
  real := ap_data_get_struct(This);
  dlv_FileName := dl_String(FileName);
  real.SaveToFile( dlv_FileName );
  result := This;
end;

function TreeView_save_to_stream(This, Stream : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_Stream : TStream;
begin
  real := ap_data_get_struct(This);
  dlv_Stream := ap_data_get_struct(Stream);
  real.SaveToStream( dlv_Stream );
  result := This;
end;

function TreeView_get_drop_target(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
begin
  real := ap_data_get_struct(This);
  result := ap_TreeNode(real.DropTarget);
end;

function TreeView_set_drop_target(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
begin
  real := ap_data_get_struct(This);
  real.DropTarget := dl_TreeNode(v);
  result := v;
end;

function TreeView_get_top_item(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
begin
  real := ap_data_get_struct(This);
  result := ap_TreeNode(real.TopItem);
end;

function TreeView_set_top_item(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
begin
  real := ap_data_get_struct(This);
  real.TopItem := dl_TreeNode(v);
  result := v;
end;

function TreeView_deselect(This, Node : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_Node : TTreeNode;
begin
  real := ap_data_get_struct(This);
  dlv_Node := dl_TreeNode(Node);
  real.Deselect( dlv_Node );
  result := This;
end;

function TreeView_subselect(This, Node, Validate : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_Node : TTreeNode;
  dlv_Validate : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_Node := dl_TreeNode(Node);
  dlv_Validate := dl_Boolean(Validate);
  real.Subselect( dlv_Node, dlv_Validate );
  result := This;
end;

function TreeView_get_selection_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.SelectionCount);
end;

function TreeView_get_selections(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_TreeNode(real.Selections[dlv_Index]);
end;

function TreeView_clear_selection(This, KeepPrimary : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
  dlv_KeepPrimary : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_KeepPrimary := dl_Boolean(KeepPrimary);
  real.ClearSelection( dlv_KeepPrimary );
  result := This;
end;

function TreeView_find_next_to_select(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_TreeView;
begin
  real := ap_data_get_struct(This);
  result := ap_TreeNode(real.FindNextToSelect);
end;
(**** made by ap_src_maker ****)

procedure Init_TreeView;
begin
{$IFDEF VCL}
  OutputConstSetType(mPhi, TypeInfo(THitTest));
{$ENDIF}

  cTreeView := OutputPersistentClass(mPhi, TTreeView, cWinControl, ap_iTreeView_v);
  rb_define_method(cTreeView, 'event_handle', @TreeView_event_handle, 1);
  rb_define_alloc_func(cTreeView, @TreeView_allocate);
  rb_define_method(cTreeView, 'load', @TreeView_load, 1);
  rb_define_method(cTreeView, 'save', @TreeView_save, 1);
  DefineAttrGet(cTreeView, 'selected', TreeView_get_selected);
  DefineAttrSet(cTreeView, 'selected', TreeView_set_selected);
  rb_define_method(cTreeView, 'get_node_at', @TreeView_get_node_at, 2);
  rb_define_method(cTreeView, 'full_expand', @TreeView_full_expand, 0);
  rb_define_method(cTreeView, 'full_collapse', @TreeView_full_collapse, 0);
{$IFDEF VCL}
  rb_define_method(cTreeView, 'get_hit_test_info_at', @TreeView_get_hit_test_info_at, 2);
{$ENDIF}
  rb_define_attr(cTreeView, 'canvas', 1, 0);
  rb_define_attr(cTreeView, 'font', 1, 0);
  rb_define_attr(cTreeView, 'items', 1, 0);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cTreeView, 'alpha_sort', @TreeView_alpha_sort, 1);
  rb_define_method(cTreeView, 'is_editing', @TreeView_is_editing, 0);
  rb_define_alias(cTreeView , 'editing?', 'is_editing');
  rb_define_method(cTreeView, 'load_from_file', @TreeView_load_from_file, 1);
  rb_define_method(cTreeView, 'load_from_stream', @TreeView_load_from_stream, 1);
  rb_define_method(cTreeView, 'save_to_file', @TreeView_save_to_file, 1);
  rb_define_method(cTreeView, 'save_to_stream', @TreeView_save_to_stream, 1);
  DefineAttrGet(cTreeView, 'drop_target', TreeView_get_drop_target);
  DefineAttrSet(cTreeView, 'drop_target', TreeView_set_drop_target);
  DefineAttrGet(cTreeView, 'top_item', TreeView_get_top_item);
  DefineAttrSet(cTreeView, 'top_item', TreeView_set_top_item);
  rb_define_method(cTreeView, 'deselect', @TreeView_deselect, 1);
  rb_define_method(cTreeView, 'subselect', @TreeView_subselect, 2);
  DefineAttrGet(cTreeView, 'selection_count', TreeView_get_selection_count);
  rb_define_method(cTreeView, 'clear_selection', @TreeView_clear_selection, 1);
  rb_define_method(cTreeView, 'get_selections', @TreeView_get_selections, 1);
  rb_define_method(cTreeView, 'find_next_to_select', @TreeView_find_next_to_select, 0);
(**** made by ap_src_maker ****)

end;

end.
