unit uMemo;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cMemo: Tvalue;

function ap_cMemo: Tvalue;
function ap_iMemo(real: TMemo; owner: Tvalue): Tvalue;
procedure Init_Memo;

implementation

uses
  Classes,
  uConv, uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont, uStrings, uPoint,
  uPersistent, uComponent, uControl, uEdit;

function ap_cMemo: Tvalue;
begin
  result := cMemo;
end;

procedure Memo_setup(obj: Tvalue; real: TMemo);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@lines', ap_iStrings(real.Lines, obj));
//    AssignPropMethod(real, [Handle]);
end;

function Memo_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Memo_alloc(klass: Tvalue; real: TMemo): Tvalue;
begin
  result := ChildAlloc(klass, real);
  Memo_setup(result, real);
end;

function ap_iMemo(real: TMemo; owner: Tvalue): Tvalue;
begin
  result := Memo_alloc(cMemo, real);
  ap_owner(result, owner);
end;

function ap_iMemo_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iMemo(TMemo(AControl), owner);
end;

function Memo_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := TMemo.Create(nil);
  result := CompoAlloc(This, real);
  Memo_setup(result, real);
end;

function Memo_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := This;
end;

function Memo_set_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
  real.Text := dl_String(v);
  result := v;
end;

function Memo_get_text(This: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.Text));
end;
(*
function Memo_set_caret_pos(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
  real.CaretPos := TPoint(ap_data_get_struct(v)^);
  result := v;
end;
*)
function Memo_get_caret_pos(This: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
{$IFDEF VCL}
  result := ap_iPoint(real.CaretPos, Qnil);
{$ELSE}
  result := Qnil;
{$ENDIF}
end;

procedure Init_Memo;
begin
  OutputConstSetType(mPhi, TypeInfo(TScrollStyle));
  cMemo := OutputPersistentClass(mPhi, TMemo, cEdit, ap_iMemo_v);
  rb_define_method(cMemo, 'event_handle', @Memo_event_handle, 1);
  rb_define_alloc_func(cMemo, @Memo_allocate);
  rb_define_method(cMemo, 'clear', @Memo_clear, 0);
  DefineAttrSet(cMemo, 'text', Memo_set_text);
  DefineAttrGet(cMemo, 'text', Memo_get_text);
//  DefineAttrSet(cMemo, 'caret_pos', Memo_set_caret_pos);
  DefineAttrGet(cMemo, 'caret_pos', Memo_get_caret_pos);
end;

end.
