require "test/unit"
require "phi"
class TCLabel < Test::Unit::TestCase
  def test_ancestors
    assert_equal Phi::Control, Phi::Label.superclass
  end

  def setup
    @form = Phi::Form.new(:form)
  end

  def test_tag
    instance = Phi::Label.new(@form, :label)
    assert_raise(NoMethodError) { instance.tag }
  end

  def test_new_name_default
    instance = Phi::Label.new(@form)
    assert_equal 'Label1', instance.name
    assert_equal instance, @form.instance_eval { @Label1 }
    assert_equal instance, @form.instance_eval { self.Label1 }
  end

  def test_new_name
    instance = Phi::Label.new(@form, :label)
    assert_equal 'label', instance.name
    assert_equal instance, @form.instance_eval { @label }
    assert_equal instance, @form.instance_eval { self.label }
  end

  def test_new_text_default
    instance = Phi::Label.new(@form, :label)
    assert_equal '', instance.caption
  end

  def test_new_text
    instance = Phi::Label.new(@form, :label, 'hello')
    assert_equal 'hello', instance.caption
  end

  def test_font
    instance = Phi::Label.new(@form, :label)
    assert_instance_of Phi::Font, instance.font
  end
end

class SubLabel < Phi::Label
  def initialize(*args)
    @form = Phi::Form.new(:form)
    super(@form, :label, *args)
  end
end

class TCSubLabel < Test::Unit::TestCase
  def test_new
    instance = nil
    assert_nothing_raised { instance = SubLabel.new('ab.cd') }
    assert_equal 'label', instance.name
    assert_equal 'ab.cd', instance.caption
  end
end
