require "test/unit"
require "phi"
class TCForm < Test::Unit::TestCase
  def test_ancestors
    assert_equal Phi::WinControl, Phi::Form.superclass
  end

  def test_new_iv
    instance = Phi::Form.new(:form)
    assert_equal Hash.new, instance.instance_eval { @events }
    assert_equal Phi::SCREEN, instance.instance_eval { @parent }
  end

  def test_tag
    instance = Phi::Form.new(:form)
    assert_raise(NoMethodError) { instance.tag }
  end

  def test_new_bounds
    instance = Phi::Form.new(:form)
    assert_equal 320, instance.width
    assert_equal 200, instance.height
    expected_left = (Phi::SCREEN.width  - 320)/2
    expected_top  = (Phi::SCREEN.height - 200)/2
    assert_equal expected_left, instance.left
    assert_equal expected_top , instance.top
  end

  def test_new_name_default
    instance = Phi::Form.new
    assert_equal 'Form1', instance.name
    assert_equal instance, Phi::SCREEN.instance_eval { @Form1 }
    assert_equal instance, Phi::SCREEN.instance_eval { self.Form1 }
    # instance.name = nil
  end

  # TODO: name='' Ɠɂׂ
  def test_new_name_nil
    assert_raise(TypeError) { instance = Phi::Form.new(nil) }
    # assert_equal 'Form1', instance.name
    # instance.name = nil
  end

  def test_new_name
    instance = Phi::Form.new(:form)
    assert_equal 'form', instance.name
    assert_equal instance, Phi::SCREEN.instance_eval { @form }
    assert_equal instance, Phi::SCREEN.instance_eval { self.form }
  end

  def with_scope_delphian_auto_name(value)
    orig_delphian_auto_name = Phi::DELPHIAN_AUTO_NAME
    Phi.module_eval { remove_const('DELPHIAN_AUTO_NAME') }
    Phi.const_set('DELPHIAN_AUTO_NAME', value)
    begin
      yield
    ensure
      Phi.module_eval { remove_const('DELPHIAN_AUTO_NAME') }
      Phi.const_set('DELPHIAN_AUTO_NAME', orig_delphian_auto_name)
    end
  end

  # TODO: object_id << 1 rubyɂ̂ł܂ǂȂ
  def test_new_name_without_delphian_auto_name
    with_scope_delphian_auto_name(false) do
      instance = Phi::Form.new
      assert_equal 'c_%s' % (instance.object_id << 1), instance.name
    end
  end

  def test_new_caption_default
    instance = Phi::Form.new(:form)
    assert_equal '', instance.caption
  end

  def test_new_caption
    instance = Phi::Form.new(:form, 'hello')
    assert_equal 'hello', instance.caption
  end
end
